package com.elitesland.tw.tw5.api.prd.my.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.List;

/**
 * 远程办公申请明细
 *
 * @author wangly
 * @date 2024-06-12
 */
@Getter
@Setter
public class AbnormalWorkApplyDetailQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 远程办公申请ID 精确
     */
    @ApiModelProperty("远程办公申请ID")
    private Long applyId;
    /**
     * 月份 精确
     */
    @ApiModelProperty("月份")
    private String workMonth;
    /**
     * 远程办公日期 精确
     */
    @ApiModelProperty("远程办公日期")
    private LocalDate workDate;
    /**
     * 远程办公天数 精确
     */
    @ApiModelProperty("远程办公天数")
    private BigDecimal workDays;
    /**
     * 0.5天区分上午下午 AM上午 PM下午 精确
     */
    @ApiModelProperty("0.5天区分上午下午 AM上午 PM下午")
    private String workInterval;
    /**
     * 流程实例ID 精确
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 审批时间 精确
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    // 主表字段

    /**
     * 事由类型
     */
    @ApiModelProperty("事由类型")
    private String reasonType;

    /**
     *事由ID
     */
    @ApiModelProperty("事由ID")
    private Long reasonId;

    /**
     * 申请日期开始 精确
     */
    @ApiModelProperty("申请日期开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate applyStartDate;
    /**
     * 申请日期开始 精确
     */
    @ApiModelProperty("申请日期结束")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate applyEndDate;

    /**
     * 审批状态 精确
     */
    @ApiModelProperty("审批状态")
    private String procInstStatus;

    /**
     * 外出申请人id 精确
     */
    @ApiModelProperty("外出申请人id")
    private Long applyUserId;
    /**
     * 归属bu_id 精确
     */
    @ApiModelProperty("归属bu_id")
    private Long orgId;

    @ApiModelProperty("远程办公日期开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate abnormalWorkStartDate;

    @ApiModelProperty("远程办公日期结束")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate abnormalWorkEndDate;
}
