package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TaskPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TaskQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.ProjectAndTaskVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TaskVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;

import java.util.List;
import java.util.Map;

/**
 * 工时用-任务表
 *
 * @author duwh
 * @date 2022-12-09
 */
@Deprecated
public interface TaskService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TaskVO}>
     */
    PagingVO<TaskVO> paging(TaskQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TaskVO}>
     */
    List<TaskVO> queryList(TaskQuery query);

    /**
     * 工作计划 下拉选择用
     *
     * @param query 查询
     * @return {@link List}<{@link ProjectAndTaskVO}>
     */
    List<ProjectAndTaskVO> queryListForSelect(TaskQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TaskVO}
     */
    TaskVO queryByKey(Long key);

    TaskVO queryByTaskIdV4(Long taskIdV4);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TaskVO}
     */
    TaskVO insert(TaskPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TaskVO}
     */
    TaskVO update(TaskPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 根据项目查询任务包信息
     *
     * @param query    查询
     * @param projIdV4 项目id v4
     * @param test
     * @return {@link List}<{@link TaskVO}>
     */
    List<TaskVO> selectTaskForTimesheet(TaskQuery query, Long projIdV4, boolean test);

    Map<Long, Long> getV4AndV5TaskIds();


    String updateTaskStatus(Long id, String status);

    /**
     * 根据任务主键判断是否是基于授权的任务包
     * 根据授权配置 取审批人是PM(项目经理) or PL（授权接收资源）
     *
     * @param taskId 任务id
     * @return {@link Long}
     */
    Long getApprResIdByAuthInfo(Long taskId);


    String updateTaskReason(Long taskId, String reasonType, Long reasonId, Long expenseBuId);

    /**
     * 获取当前项目的发包人列表（项目经理+任务包被授权人）
     * @param projectId
     * @return
     */
    List<PrdOrgEmployeeVO> getDisterUserIds(Long projectId);
}
