package com.elitesland.tw.tw5.api.prd.org.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;

@Data
public class YeedocEmployeeVO extends BaseViewModel {


    @ApiModelProperty("用户账号")
    private String userName;

    @ApiModelProperty("用户最终名称")
    private String lastName;
    /**
     * 角色IDs
     */
    private List<Long> roleIds;
    /**
     * 角色数据
     */
    private List<PrdSystemRoleVO> roleDatas;

    @ApiModelProperty("用户电话")
    private String mobile;

    @ApiModelProperty("用户邮箱")
    private String email;

    @ApiModelProperty("账户状态")
    private Boolean enabled;

    @ApiModelProperty("自然人ID")
    private Long personId;
    /**
     * 用户真实姓名
     */
    @ApiModelProperty("用户真实姓名")
    private String personName;

    @ApiModelProperty("系统用户ID")
    private Long userId;

    @ApiModelProperty("公司ID")
    private Long companyId;

    @ApiModelProperty("公司名称")
    private String companyName;

    /**
     * 企业微信号
     */
    private String wecomId;

    @ApiModelProperty("员工编号")
    private String employeeNo;

    @ApiModelProperty("员工名称")
    private String employeeName;

    @ApiModelProperty("资源状态")
    private String resourceStatus;

    @ApiModelProperty("资源状态名称")
    private String resourceName;

    @ApiModelProperty("人事状态")
    private String hrStatus;//0：有效，1：无效

    @ApiModelProperty("人事状态名称")
    private String hrName;


    @ApiModelProperty("入职日期")
    private LocalDate enrollDate;

    @ApiModelProperty("安全级别")
    private Integer accessLevel;

    @ApiModelProperty("岗位")
    private String jobs;

    @ApiModelProperty("岗位名称")
    private String jobsName;

    @ApiModelProperty("排序")
    private Integer sortIndex;


    @ApiModelProperty("外文名")
    private String foreignName;

    @ApiModelProperty("证件类型")
    private String idType;

    @ApiModelProperty("证件类型名称")
    private String idTypeName;

    @ApiModelProperty("证件号码")
    private String idNo;

    @ApiModelProperty("证件开始日")
    private LocalDate idValidFrom;

    @ApiModelProperty("证件到期日")
    private LocalDate idValidTo;

    /**
     * 证件url
     */
    private String idValidCodes;
    private Object idValidDatas;

    /**
     * 头像url
     */
    private String headCodes;
    private Object headDatas;

    @ApiModelProperty("生日")
    private LocalDate birthday;

    @ApiModelProperty("性别")
    private String sex;
    @ApiModelProperty("性别名称")
    private String sexName;

    @ApiModelProperty("国籍")
    private String nationality;

    @ApiModelProperty("籍贯")
    private String birthplace;

    @ApiModelProperty("民族")
    private String nation;

    @ApiModelProperty("婚姻状况")
    private Integer marital;

    @ApiModelProperty("通讯地址")
    private String addr;

    @ApiModelProperty("紧急联系人")
    private String urgency_name;

    @ApiModelProperty("手机号")
    private String urgency_mobile;

    @ApiModelProperty("关系")
    private String urgency_ref;

    @ApiModelProperty("默认组织id")
    private Long orgId;

    @ApiModelProperty("默认组织名称")
    private String orgName;

    /**
     * 上级员工编号
     */
    @ApiModelProperty("上级员工编号")
    private String parentNo;

    @ApiModelProperty("上级ID")
    private Long parentId;

    /**
     * 上级员工名称
     */
    @ApiModelProperty("上级员工名称")
    private String parentName;

    @ApiModelProperty("组织关系")
    private List<PrdOrgDataRefVO> dataRefVOS;

    /**
     * 专业级别
     */
    private String extString1;
    /**
     * 管理级别
     */
    private String extString2;
    /**
     * 专业序列
     */
    private String extString3;
    /**
     * 职位序列
     */
    private String extString4;
    /**
     * 主服务地址
     */
    private String extString5;
    /**
     * 内部类型
     */
    private String extString6;
    /**
     * 话费额度
     */
    private String extString7;
    /**
     * 电脑额度
     */
    private String extString8;
    private String extString9;
    private String extString10;
    private String extString11;
    private String extString12;

}
