package com.elitesland.tw.tw5.api.prd.partner.business.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.business.payload.BusinessOperationSitesPayload;
import com.elitesland.tw.tw5.api.prd.partner.business.query.BusinessOperationSitesQuery;
import com.elitesland.tw.tw5.api.prd.partner.business.vo.BusinessOperationSitesVO;

import java.util.List;

/**
 * 业务伙伴-年报网址
 *
 * @author wangly
 * @date 2023-05-16
 */
public interface BusinessOperationSitesService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessOperationSitesVO}>
     */
    PagingVO<BusinessOperationSitesVO> queryPaging(BusinessOperationSitesQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessOperationSitesVO}>
     */
    List<BusinessOperationSitesVO> queryListDynamic(BusinessOperationSitesQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessOperationSitesVO}
     */
    BusinessOperationSitesVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessOperationSitesVO}
     */
    BusinessOperationSitesVO insert(BusinessOperationSitesPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessOperationSitesVO}
     */
    BusinessOperationSitesVO update(BusinessOperationSitesPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 通过partnerId删除
     *
     * @param partnerId 业务伙伴id
     */
    void deleteByPartnerId(Long partnerId);
}
