package com.elitesland.tw.tw5.api.prd.partner.common.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 业务伙伴-发票信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Getter
@Setter
public class BookInvoicePayload extends TwCommonPayload  implements Serializable {
    /** 地址薄id */
    @ApiModelProperty("地址薄id")
    private Long bookId;
    /** 业务伙伴主键 business_partner.id */
    @ApiModelProperty("业务伙伴主键 business_partner.id")
    private Long partnerId;
    /** 发票信息 */
    @ApiModelProperty("发票信息")
    private String invoiceMessage;
    /** 发票抬头 */
    @ApiModelProperty("发票抬头")
    private String invoiceTitle;
    /** 税率 udc[prd:ab:tax_rate] */
    @ApiModelProperty("税率 udc[prd:ab:tax_rate]")
    private String taxRete;
    /** 税号 */
    @ApiModelProperty("税号")
    private String taxNo;
    /** 开票类型 udc[prd:ab:inv_type] */
    @ApiModelProperty("开票类型 udc[prd:ab:inv_type]")
    private String invoiceType;
    /** 开票地址 */
    @ApiModelProperty("开票地址")
    private String invoiceAddress;
    /** 电话 */
    @ApiModelProperty("电话")
    private String invoicePhone;
    /** 开户行 */
    @ApiModelProperty("开户行")
    private String depositBank;
    /** 账户 */
    @ApiModelProperty("账户")
    private String invoiceAccount;
    /** 币种 udc[SYSTEM_BASIC:CURRENCY] */
    @ApiModelProperty("币种 udc[SYSTEM_BASIC:CURRENCY]")
    private String currency;
    /** 是否为默认开票信息 */
    @ApiModelProperty("是否为默认开票信息")
    private Boolean isDefault;
}
