package com.elitesland.tw.tw5.api.prd.partner.common.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 业务伙伴管理
 *
 * @author wangluyu
 * @date 2023-05-16
 */
@Getter
@Setter
public class BusinessPartnerQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private List<Long> ids;
    /**
     * 业务伙伴编号 精确
     */
    @ApiModelProperty("业务伙伴编号")
    private String businessPartnerNo;
    /**
     * 业务伙伴名称 精确
     */
    @ApiModelProperty("业务伙伴名称")
    private String partnerName;
    /**
     * 业务伙伴身份 udc[CRM:BUSINESS_PARTNER:IDENTITY] 精确
     */
    @ApiModelProperty("业务伙伴身份 udc[CRM:BUSINESS_PARTNER:IDENTITY]")
    private String partnerIdentity;
    /**
     * 类型 udc[CRM:BUSINESS_PARTNER:TYPE]
     */
    @ApiModelProperty("类型 udc[CRM:BUSINESS_PARTNER:TYPE]")
    private String partnerType;
    /**
     * 行业 udc[crm:leads_customer_industry] 精确
     */
    @ApiModelProperty("行业 udc[crm:leads_customer_industry]")
    private String partnerIndustry;
    /**
     * 性质 udc[crm:company_nature]
     */
    @ApiModelProperty("性质 udc[crm:company_nature]")
    private String partnerNature;
    /**
     * 国家
     */
    @ApiModelProperty("国家")
    private String country;
    /**
     * 省 精确
     */
    @ApiModelProperty("省")
    private String province;
    /**
     * 市 精确
     */
    @ApiModelProperty("市")
    private String city;
    /**
     * 区 精确
     */
    @ApiModelProperty("区")
    private String district;

    /**
     * 省 精确
     */
    @ApiModelProperty("省")
    private String provinceName;
    /**
     * 市 精确
     */
    @ApiModelProperty("市")
    private String cityName;
    /**
     * 区 精确
     */
    @ApiModelProperty("区")
    private String districtName;

    /**
     * 用户id集合 移动端销售统计需求
     */
    @ApiModelProperty("用户id")
    private List<Long> userIdList;
    /**
     * 行业 udc[crm:leads_customer_industry] 精确
     */
    @ApiModelProperty("行业 udc[crm:leads_customer_industry]")
    private List<String> partnerIndustryList;
    /**
     * 性质 udc[crm:company_nature]
     */
    @ApiModelProperty("性质 udc[crm:company_nature]")
    private List<String> partnerNatureList;
    /**
     * 国家
     */
    @ApiModelProperty("国家")
    private List<String> countryList;

    /**
     * 业务伙伴区域
     */
    @ApiModelProperty("业务伙伴区域 udc[crm:customer_region]")
    private String partnerRegion;

    /**
     * 客户状态
     */
    @ApiModelProperty("客户状态")
    private String customerStatus;

    /**
     * 合作伙伴状态
     */
    @ApiModelProperty("合作伙伴状态")
    private String collaborateStatus;

    /**
     * 供应商状态
     */
    @ApiModelProperty("供应商状态")
    private String supplierStatus;

    /**
     * 拓展字段1
     */
    @ApiModelProperty("分公司-组织编号")
    private String ext1;
    /**
     * 拓展字段2
     */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /**
     * 拓展字段3
     */
    @ApiModelProperty("拓展字段3")
    private String ext3;
    /**
     * 拓展字段4
     */
    @ApiModelProperty("拓展字段4")
    private String ext4;
    /**
     * 拓展字段5
     */
    @ApiModelProperty("拓展字段5")
    private String ext5;
    /**
     * 内部/外部
     */
    @ApiModelProperty("内部/外部 udc[CRM:BUSINESS_PARTNER:INSIDE_OR_OUTSIDE]")
    private String insideOrOutSide;
    /**
     * 待确认潜在客户
     */
    @ApiModelProperty("待确认潜在客户")
    private Boolean confirmFlag;

    /**
     * 需要权限
     */
    private Boolean permissionFlag = false;

    /**
     * 当前登录用户id
     */
    private Long loginUserId;
}
