package com.elitesland.tw.tw5.api.prd.partner.identity.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;


/**
 * 业务伙伴-供应商信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Getter
@Setter
public class BusinessSupplierInfoVO extends BaseViewModel implements Serializable {
    /**
     * 业务伙伴id business_partner.id
     */
    @ApiModelProperty("业务伙伴id")
    private Long partnerId;
    /**
     * 供应商编号
     */
    @ApiModelProperty("供应商编号")
    private String supplierNo;
    /**
     * 供应商状态 udc[CRM:BUSINESS_PARTNER:STATUS]
     */
    @ApiModelProperty("供应商状态 udc[CRM:BUSINESS_PARTNER:STATUS]")
    private String supplierStatus;

    /**
     * 供应商状态 udc[CRM:BUSINESS_PARTNER:STATUS]
     */
    @ApiModelProperty("供应商状态 udc[CRM:BUSINESS_PARTNER:STATUS]")
    @UdcName(udcName = "CRM:BUSINESS_PARTNER:STATUS", codePropName = "supplierStatus")
    private String supplierStatusDesc;

    /**
     * 供应商级别 udc[crm:customer_grade]
     */
    @ApiModelProperty("供应商级别 udc[crm:customer_grade]")
    private String supplierGradle;

    /**
     * 供应商级别 udc[crm:customer_grade]
     */
    @ApiModelProperty("供应商级别 udc[crm:customer_grade]")
    @UdcName(udcName = "crm:customer_grade", codePropName = "supplierGradle")
    private String supplierGradleDesc;

    /**
     * 供应商产品
     */
    @ApiModelProperty("供应商产品")
    private String supplierProduct;

    /**
     * 供货开始时间
     */
    @ApiModelProperty("供货开始时间")
    private LocalDate startTime;

    /**
     * 供货结束时间
     */
    @ApiModelProperty("供货结束时间")
    private LocalDate endTime;

    /**
     * 结算周期
     */
    @ApiModelProperty("结算周期")
    private String settlementPeriod;

    /**
     * 供货期间说明
     */
    @ApiModelProperty("供货期间说明")
    private String supplyDescription;

    /**
     * 资质审核资料附件
     */
    @ApiModelProperty("资质审核资料附件")
    private String fileCode1;

    /**
     * 实地考察资料 附件
     */
    @ApiModelProperty("实地考察资料")
    private String fileCode2;

    /**
     * 资质审核资料附件
     */
    @ApiModelProperty("资质审核资料附件")
    private Object fileData1;

    /**
     * 实地考察资料
     */
    @ApiModelProperty("实地考察资料")
    private Object fileData2;

    /**
     * 扩展字段1
     */
    @ApiModelProperty("扩展字段1")
    private String ext1;

    /**
     * 扩展字段2
     */
    @ApiModelProperty("扩展字段2")
    private String ext2;

    /**
     * 扩展字段3
     */
    @ApiModelProperty("扩展字段3")
    private String ext3;

    /**
     * 扩展字段4
     */
    @ApiModelProperty("扩展字段4")
    private String ext4;

    /**
     * 扩展字段5
     */
    @ApiModelProperty("扩展字段5")
    private String ext5;

    /**
     * 采购负责人
     */
    @ApiModelProperty("采购负责人")
    private Long purchaseInchargeResId;

    /**
     * 采购负责人
     */
    @ApiModelProperty("采购负责人名称")
    private String purchaseInchargeResName;

    /**
     * 是否同步过JDE
     */
    @ApiModelProperty("是否同步过JDE")
    private Boolean syncJdeFlag;
}
