package com.elitesland.tw.tw5.api.prd.partner.strategy.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 分级策略
 *
 * @author wangly
 * @date 2023-06-16
 */
@Getter
@Setter
public class BusinessStrategyQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 策略编号 精确 */
    @ApiModelProperty("策略编号")
    private String strategyNo;
    /** 分级策略名称 精确 */
    @ApiModelProperty("分级策略名称")
    private String strategyName;
    /** 分级策略适用身份 udc[CRM:BUSINESS_PARTNER:IDENTITY] 精确 */
    @ApiModelProperty("分级策略适用身份 udc[CRM:BUSINESS_PARTNER:IDENTITY]")
    private String strategyIdentity;
    /** 策略状态 udc[CRM:BUSINESS_STRATEGY:STATUS] 精确 */
    @ApiModelProperty("策略状态 udc[CRM:BUSINESS_STRATEGY:STATUS]")
    private String strategyStatus;
    /** 策略优先级 udc[CRM:BUSINESS_STRATEGY:PRIORITY] 精确 */
    @ApiModelProperty("策略优先级 udc[CRM:BUSINESS_STRATEGY:PRIORITY]")
    private String strategyPriority;
    /** 策略范围 udc[CRM:BUSINESS_STRATEGY:RANGE] 精确 */
    @ApiModelProperty("策略范围 udc[CRM:BUSINESS_STRATEGY:RANGE]")
    private String strategyRange;
    /** 排序号 精确 */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /** 拓展字段1 精确 */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /** 拓展字段2 精确 */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /** 拓展字段3 精确 */
    @ApiModelProperty("拓展字段3")
    private String ext3;
    /** 拓展字段4 精确 */
    @ApiModelProperty("拓展字段4")
    private String ext4;
    /** 拓展字段5 精确 */
    @ApiModelProperty("拓展字段5")
    private String ext5;
    /** 策略范围明细 精确 */
    @ApiModelProperty("策略范围明细")
    private String strategyRangeDetail;
}
