package com.elitesland.tw.tw5.api.prd.pms.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 项目模板活动
 *
 * @author xxb
 * @date 2023-08-03
 */
@Getter
@Setter
public class PmsProjectTemplateActQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 模板Id 精确 */
    @ApiModelProperty("模板Id")
    private Long templateId;
    /** 活动编号 精确 */
    @ApiModelProperty("活动编号")
    private String actCode;
    /** 活动名称 精确 */
    @ApiModelProperty("活动名称")
    private String actName;
    /** 规划天数 精确 */
    @ApiModelProperty("规划天数")
    private BigDecimal plannedDays;
    /** 规划当量 精确 */
    @ApiModelProperty("规划当量")
    private BigDecimal planningEquivalent;
    /** 里程碑标记 1是 0不是 精确 */
    @ApiModelProperty("里程碑标记 1是 0不是")
    private Integer milestoneFlag;
    /** 阶段标记 1是 0不是 精确 */
    @ApiModelProperty("阶段标记 1是 0不是")
    private Integer actStageFlag;
}
