package com.elitesland.tw.tw5.api.prd.purchase.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 采购协议明细
 *
 * @author Echo
 * @date 2023-06-08
 */
@Getter
@Setter
public class PurchaseAgreementDetailsPayload extends TwCommonPayload  implements Serializable {
    /** 采购协议id */
    @ApiModelProperty("采购协议id")
    private Long agreementId;
    /** 关联产品 */
    @ApiModelProperty("关联产品")
    private Long relatedProductId;
    /** 采购产品 */
    @ApiModelProperty("采购产品")
    private String productName;
    /** 产品大类 */
    @ApiModelProperty("产品大类")
    private String classId;
    /** 产品小类 */
    @ApiModelProperty("产品小类")
    private String subClassId;
    /** 数量 */
    @ApiModelProperty("数量")
    private BigDecimal quantity;
    /** 含税单价 */
    @ApiModelProperty("含税单价")
    private BigDecimal taxPrice;
    /** 税率 */
    @ApiModelProperty("税率")
    private String taxRate;
    /** 含税总额 */
    @ApiModelProperty("含税总额")
    private BigDecimal taxAmt;
    /** 不含税总额 */
    @ApiModelProperty("不含税总额")
    private BigDecimal taxNotAmt;
    /** 交期 */
    @ApiModelProperty("交期")
    private LocalDate deliveryDate;
    /** 说明 */
    @ApiModelProperty("说明")
    private String note;
}
