package com.elitesland.tw.tw5.api.prd.purchase.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseAgreementAssociationPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseAgreementAssociationQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementAssociationVO;

import java.util.List;

/**
 * 采购协议关联协议
 *
 * @author Echo
 * @date 2023-06-08
 */
public interface PurchaseAgreementAssociationService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PurchaseAgreementAssociationVO}>
     */
    PagingVO<PurchaseAgreementAssociationVO> queryPaging(PurchaseAgreementAssociationQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PurchaseAgreementAssociationVO}>
     */
    List<PurchaseAgreementAssociationVO> queryListDynamic(PurchaseAgreementAssociationQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PurchaseAgreementAssociationVO}
     */
    PurchaseAgreementAssociationVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PurchaseAgreementAssociationVO}
     */
    PurchaseAgreementAssociationVO insert(PurchaseAgreementAssociationPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PurchaseAgreementAssociationVO}
     */
    PurchaseAgreementAssociationVO update(PurchaseAgreementAssociationPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PurchaseAgreementAssociationPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 删除关联协议
     * @param documentIdList 协议IdList
     */
    void deleteSoftByDocumentIdList(List<Long> documentIdList);
}
