package com.elitesland.tw.tw5.api.prd.purchase.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchasePaymentPlanPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.LatePaymentPlanQuery;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseAgreementPaymentQuery;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchasePaymentPlanQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.LatePaymentPlanVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentPlanVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * 采购合同管理
 *
 * @author lipengfei
 * @date 2023-05-30
 */
public interface PurchasePaymentPlanService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PurchasePaymentPlanVO}>
     */
    PagingVO<PurchasePaymentPlanVO> queryPaging(PurchasePaymentPlanQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PurchasePaymentPlanVO}>
     */
    List<PurchasePaymentPlanVO> queryListDynamic(PurchasePaymentPlanQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PurchasePaymentPlanVO}
     */
    PurchasePaymentPlanVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PurchasePaymentPlanVO}
     */
    PurchasePaymentPlanVO insert(PurchasePaymentPlanPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PurchasePaymentPlanVO}
     */
    PurchasePaymentPlanVO update(PurchasePaymentPlanPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 根据合同编号查询付款计划
     * @param docNo 合同编号
     * @param applyIdIsNull 申请单ID是否为null
     * @return 付款计划
     */
    List<PurchasePaymentPlanVO> findListByConNo(String docNo, Boolean applyIdIsNull);

    /**
     * 根据付款申请单ID查询列表
     *
     * @param paymentApplyId 付款申请单ID
     * @return {@link List}<{@link PurchasePaymentPlanVO}>
     */
    List<PurchasePaymentPlanVO> queryListByPaymentApplyId(Long paymentApplyId);

    /**
     * 根据付款申请单查询付款计划列表
     *
     * @param purchasePaymentVO 付款申请单
     */
    void setPaymentApplyVOPlanList(PurchasePaymentVO purchasePaymentVO);

    /**
     * 将付款申请单Id置空
     * @param paymentApplyId 付款申请单Id
     */
    void resettingPlanByPaymentId(Long paymentApplyId);

    /**
     * 批量修改付款计划
     * @param purchasePaymentPlanPayloads 要修改的付款计划
     */
    void updatePlans(List<PurchasePaymentPlanPayload> purchasePaymentPlanPayloads);

    /**
     * 批量新增付款计划
     * @param purchasePaymentPlanPayloads 要新增的付款计划
     */
    void insertAll(List<PurchasePaymentPlanPayload> purchasePaymentPlanPayloads);

    /**
     * 根据付款申请单ID删除付款计划
     * @param id 付款申请单Id
     */
    void deleteByPaymentId(Long id);

    /**
     * 逾期付款计划
     * @param latePaymentPlanQuery 查询条件
     * @return 结果
     */
    PagingVO<LatePaymentPlanVO> findLatePaymentPlanList(LatePaymentPlanQuery latePaymentPlanQuery);

    /**
     * 根据采购协议编号查询付款明细
     * @param query 查询条件
     * @return 付款明细
     */
    PagingVO<PurchasePaymentPlanVO> findPlanListByAgreementNo(PurchaseAgreementPaymentQuery query);

    /**
     * 查询采购付款计划
     * @param purConId 采购合同Id
     * @param isIgnoreWriteOff 是否忽略掉预付款核销
     * @return 付款计划列表
     */
    List<PurchasePaymentPlanVO> queryListByConId(Long purConId, Boolean isIgnoreWriteOff);

    /**
     * 根据采购合同or采购协议编号查询预付款付款计划
     * @param conOrAgreementNo 采购合同or采购协议编号
     * @param prePaymentNo 预付款申请单编号
     * @return 付款计划
     */
    List<PurchasePaymentPlanVO> findPlanListByConOrAgreementNoAndPrePaymentNo(String conOrAgreementNo, String prePaymentNo);

    /**
     * 根据预付款申请单编号查询已核销金额
     * @param prePaymentApplyNo 预付款申请单编号
     * @return 已核销金额
     */
    BigDecimal findWriteOffAmtByPrePaymentNo(String prePaymentApplyNo);
}
