package com.elitesland.tw.tw5.api.prd.purchase.vo;

import cn.zhxu.bs.bean.DbIgnore;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;


/**
 * 付款单记录
 *
 * @author likunpeng
 * @date 2023-11-23
 */
@Getter
@Setter
@ExcelIgnoreUnannotated
public class PaymentSlipVO extends BaseViewModel implements Serializable {
    /**
     * 付款申请单ID
     */
    @ApiModelProperty("付款申请单ID")
    private Long paymentApplyId;
    /**
     * 付款流水号
     */
    @ApiModelProperty("付款流水号")
    @ExcelProperty(value = "付款流水号", index = 0)
    private String paySerialNum;
    /**
     * 付款申请单编号
     */
    @ApiModelProperty("付款申请单编号")
    @ExcelProperty(value = "付款申请单", index = 1)
    private String paymentApplyNo;
    /**
     * 付款申请单名称
     */
    @ApiModelProperty("付款申请单名称")
    @ExcelProperty(value = "付款申请单名称", index = 7)
    private String paymentApplyName;

    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String docType;
    @ApiModelProperty("关联单据类型Desc")
    @UdcName(udcName = "purchase:doc_type", codePropName = "docType")
    private String docTypeDesc;
    /**
     * 关联单据号
     */
    @ApiModelProperty("关联单据号")
    private String docNo;
    /**
     * 关联单据Id
     */
    @ApiModelProperty("关联单据Id")
    private Long docId;
    /**
     * 付款申请单类型
     */
    @ApiModelProperty("付款申请单类型")
    private String paymentApplicationType;

    /**
     * 付款事由
     */
    @ApiModelProperty("付款事由")
    @ExcelProperty(value = "付款事由", index = 8)
    private String reasonDesc;

    /**
     * 支付用途/网银用途
     */
    @ApiModelProperty("支付用途/网银用途")
    private String payPurpose;
    /**
     * 付款申请人
     */
    @ApiModelProperty("付款申请人")
    private Long purchaseInchargeResId;
    @UdcName(udcName = "USER", codePropName = "purchaseInchargeResId")
    @ExcelProperty(value = "付款申请人", index = 5)
    private String purchaseInchargeResName;
    /**
     * 付款金额
     */
    @ApiModelProperty("付款金额")
    @ExcelProperty(value = "付款金额", index = 3)
    private BigDecimal paymentAmt;
    /**
     * 货币
     */
    @ApiModelProperty("货币")
    private String currCode;
    @ApiModelProperty("货币Desc")
    @UdcName(udcName = "SYSTEM_BASIC:CURRENCY", codePropName = "currCode")
    @ExcelProperty(value = "货币", index = 4)
    private String currCodeDesc;
    /**
     * 付款日期
     */
    @ApiModelProperty("付款日期")
    private LocalDate paymentDate;

    /**
     * 付款日期
     */
    @ApiModelProperty("付款日期")
    @ExcelProperty(value = "付款日期", index = 9)
    private String paymentDateString;

    public String getPaymentDateString() {
        if (paymentDate != null) {
            return paymentDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        return paymentDateString;
    }

    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDate applicationDate;

    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private String applicationDateString;

    public String getApplicationDateString() {
        if (applicationDate != null) {
            return applicationDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        return applicationDateString;
    }

    /**
     * 应付会计备注
     */
    @ApiModelProperty("应付会计备注")
    @ExcelProperty(value = "应付会计备注", index = 10)
    private String apAccountantRemark;
    /**
     * 财务经理备注
     */
    @ApiModelProperty("财务经理备注")
    @ExcelProperty(value = "财务经理备注", index = 11)
    private String financeRemark;

    /**
     * 财务经理备注
     */
    @ApiModelProperty("CFO备注")
    @ExcelProperty(value = "CFO备注", index = 12)
    private String cfoRemark;
    /**
     * 出纳备注
     */
    @ApiModelProperty("出纳备注")
    @ExcelProperty(value = "出纳备注", index = 13)
    private String cashierRemark;
    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private String state;
    @ApiModelProperty("状态Desc")
    @UdcName(udcName = "purchase:slip_status", codePropName = "state")
    @ExcelProperty(value = "状态", index = 6)
    private String stateDesc;
    /**
     * 收款公司
     */
    @ApiModelProperty("收款公司")
    private Long receivingCompanyBookId;

    @ApiModelProperty("收款公司")
    @ExcelProperty(value = "收款公司", index = 2)
    private String receivingCompanyBookIdDesc;
    /**
     * 收款账号Id
     */
    @ApiModelProperty("收款账号Id")
    @ExcelProperty(value = "收款账号", index = 15)
    private String receivingAccount;
    /**
     * 收款账号Desc
     */
    @ApiModelProperty("收款账号Desc")
    private String receivingAccountDesc;
    /**
     * 收款银行
     */
    @ApiModelProperty("收款银行")
    @ExcelProperty(value = "收款银行", index = 14)
    private String receivingBank;

    /**
     * 付款银行
     */
    @ApiModelProperty("付款银行")
    @ExcelProperty(value = "付款银行", index = 16)
    private String paymentBank;
    /**
     * 付款账号Id
     */
    @ApiModelProperty("付款账号Id")
    private String paymentAccount;
    /**
     * 付款账号Desc
     */
    @ApiModelProperty("付款账号Desc")
    private String paymentAccountDesc;
    /**
     * 付款公司地址簿Id
     */
    @ApiModelProperty("付款公司")
    private Long payCompanyBookId;
    /**
     * 付款公司地址簿Id
     */
    @ApiModelProperty("付款公司")
    private String payCompanyBookIdDesc;
    /**
     * 科目说明
     */
    @ApiModelProperty("科目说明")
    private Long accMasId;
    /**
     * 科目说明Desc
     */
    @ApiModelProperty("科目说明Desc")
    @ExcelProperty(value = "科目说明", index = 17)
    private String accMasName;
    /**
     * 付款方式
     */
    @ApiModelProperty("付款方式")
    private String paymentMethod;

    /**
     * 付款方式
     */
    @ApiModelProperty("付款方式")
    @ExcelProperty(value = "付款方式", index = 18)
    @UdcName(udcName = "ACC:PAY_METHOD",codePropName = "paymentMethod")
    private String paymentMethodDesc;
    /**
     * 支付方式：1.网银支付 2.手动支付
     */
    @ApiModelProperty("支付方式：1.网银支付 2.手动支付")
    private Integer payMode;

    /**
     * 支付方式：1.网银支付 2.手动支付
     */
    @ApiModelProperty("支付方式：1.网银支付 2.手动支付")
    @UdcName(udcName = "ACC:PAY_MODE",codePropName = "payMode")
    @ExcelProperty(value = "支付方式", index = 19)
    private String payModeDesc;
    /**
     * 支付状态：S 成功、F 失败、撤销、D 过期、R 否决 G退票
     */
    @ApiModelProperty("支付状态：S 成功、F 失败、撤销、D 过期、R 否决 G退票")
    private String payStatus;

    /**
     * 支付状态：S 成功、F 失败、撤销、D 过期、R 否决 G退票
     */
    @ApiModelProperty("支付状态：S 成功、F 失败、撤销、D 过期、R 否决 G退票")
    @UdcName(udcName = "purchase:slip:pay_status",codePropName = "payStatus")
    @ExcelProperty(value = "支付状态", index = 20)
    private String payStatusDesc;

    /**
     * 支付时间（状态时间）
     */
    @ApiModelProperty("支付时间(状态时间)")
    private LocalDateTime payTime;

    /**
     * 支付时间（状态时间）
     */
    @ApiModelProperty("支付时间(状态时间)")
    @ExcelProperty(value = "状态时间", index = 21)
    private String payTimeString;


    public String getPayTimeString() {
        if (payTime != null) {
            return payTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        return payTimeString;
    }

    /**
     * 实际付款日期
     */
    @ApiModelProperty("实际付款日期")
    private LocalDate actualDate;

    /**
     * 实际付款日期
     */
    @ApiModelProperty("实际付款日期")
    @ExcelProperty(value = "实际付款日期", index = 22)
    private String actualDateString;

    public String getActualDateString() {
        if (actualDate != null) {
            return actualDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        return actualDateString;
    }

    /**
     * 应付会计更新时间
     */
    @ApiModelProperty("应付会计更新时间")
    private LocalDateTime apAccountantTime;

    /**
     * 应付会计更新时间
     */
    @ApiModelProperty("应付会计更新时间")
    @ExcelProperty(value = "应付会计更新时间", index = 23)
    private String apAccountantTimeString;

    public String getApAccountantTimeString() {
        if (apAccountantTime != null) {
            return apAccountantTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        return apAccountantTimeString;
    }


    /**
     * 财务经理更新时间
     */
    @ApiModelProperty("财务经理更新时间")
    private LocalDateTime financeTime;

    /**
     * 财务经理更新时间
     */
    @ApiModelProperty("财务经理更新时间")
    @ExcelProperty(value = "财务经理更新时间", index = 24)
    private String financeTimeString;

    public String getFinanceTimeString() {
        if (financeTime != null) {
            return financeTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        return financeTimeString;
    }

    /**
     * CFO更新时间
     */
    @ApiModelProperty("CFO更新时间")
    private LocalDateTime cfoTime;


    /**
     * CFO更新时间
     */
    @ApiModelProperty("CFO更新时间")
    @ExcelProperty(value = "CFO更新时间", index = 25)
    private String cfoTimeString;

    public String getCfoTimeString() {
        if (cfoTime != null) {
            return cfoTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        return cfoTimeString;
    }

    /**
     * 出纳更新时间
     */
    @ApiModelProperty("出纳更新时间")
    private LocalDateTime cashierTime;

    /**
     * 出纳更新时间
     */
    @ApiModelProperty("出纳更新时间")
    @ExcelProperty(value = "出纳更新时间", index = 26)
    private String cashierTimeString;


    public String getCashierTimeString() {
        if (cashierTime != null) {
            return cashierTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        return cashierTimeString;
    }

    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /**
     * 提交时间
     */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    /**
     * 网银提交标识 1.已提交 2.未提交
     */
    @ApiModelProperty("网银提交标识 1.已提交 2.未提交")
    private Integer bankFlag;
    /**
     * 网银提交时间
     */
    @ApiModelProperty("网银提交时间")
    private LocalDateTime bankTime;
    /**
     * 支付标识：1.已支付 ；2.待支付
     */
    @ApiModelProperty("支付标识：1.已支付 ；2.待支付")
    private Integer payFlag;

    /**
     * 合计金额
     */
    @ApiModelProperty("合计金额")
    private BigDecimal totalAmount;

}
