package com.elitesland.tw.tw5.api.prd.salecon.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * 销售合同执行情况管理
 *
 * @author sunxw
 * @date 2023-11-24
 */
@Getter
@Setter
public class SaleConExecConditionVO extends BaseViewModel implements Serializable {
    /**
     * 合同ID
     */
    @ApiModelProperty("合同ID")
    private Long contractId;
    /**
     * 签单金额
     */
    @ApiModelProperty("签单金额")
    private BigDecimal signAmt;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    @UdcName(udcName = "SYSTEM_BASIC:TAX", codePropName = "taxRate")
    private String taxRateDesc;
    /**
     * 销售费用
     */
    @ApiModelProperty("销售费用")
    private BigDecimal saleExpense;
    /**
     * 项目费用
     */
    @ApiModelProperty("项目费用")
    private BigDecimal projExpense;
    /**
     * 合同采购金额
     */
    @ApiModelProperty("合同采购金额")
    private BigDecimal purchaseAmt;
    /**
     * 过单毛利
     */
    @ApiModelProperty("过单毛利")
    private BigDecimal overOrderGross;
    /**
     * 部门毛利
     */
    @ApiModelProperty("部门毛利")
    private BigDecimal buGross;
    /**
     * 有效合同金额
     */
    @ApiModelProperty("有效合同金额")
    private BigDecimal effectConAmt;
    /**
     * 核算有效金额
     */
    @ApiModelProperty("核算有效金额")
    private BigDecimal calcEffectAmt;
    /**
     * 合同价格评级
     */
    @ApiModelProperty("合同价格评级")
    private String conPriceLevel;

    private String conPriceLevelDesc;
    /**
     * 项目计算当量
     */
    @ApiModelProperty("项目计算当量")
    private BigDecimal calcProjEquiv;
    /**
     * 项目计算核定当量
     */
    @ApiModelProperty("项目计算核定当量")
    private BigDecimal calcCheckProjEquiv;
    /**
     * 最经济交付当量
     */
    @ApiModelProperty("最经济交付当量")
    private BigDecimal economicEquiv;
    /**
     * 项目执行当量
     */
    @ApiModelProperty("项目执行当量")
    private BigDecimal projExecEquiv;
    /**
     * 统计日期
     */
    @ApiModelProperty("统计日期")
    private LocalDate statisticDate;

    /**
     * 流程实例ID 精确
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态 精确
     */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /**
     * 流程审批状态 精确
     */
    @ApiModelProperty("流程审批状态")
    @UdcName(udcName = "appr_status",codePropName = "procInstStatus")
    private String procInstStatusDesc;
    /**
     * 提交时间 精确
     */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /**
     * 审批时间 精确
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    /** 合同字段 ***/

    /**
     * 合同编号 精确
     */
    @ApiModelProperty("合同编号")
    private String code;

    /**
     * 合同名称 精确
     */
    @ApiModelProperty("合同名称")
    private String name;

    /**
     * 合同状态 精确
     */
    @ApiModelProperty("合同状态")
    private String status;

    /**
     * 合同状态 精确
     */
    @ApiModelProperty("合同状态")
    @UdcName(udcName = "salecon:status", codePropName = "status")
    private String statusDesc;


    /**
     * 客户bookId 精确
     */
    @ApiModelProperty("客户bookId")
    private Long custId;

    /**
     * 客户名称 精确
     */
    @ApiModelProperty("客户名称")
    @UdcName(udcName = "BOOK", codePropName = "custId")
    private String custName;

    /**
     * 商机id 精确
     */
    @ApiModelProperty("商机id")
    private Long oppoId;

    /**
     * 商机名称
     */
    @ApiModelProperty("商机名称")
    private String oppoName;
    /**
     * 金额 精确
     */
    @ApiModelProperty("金额")
    private BigDecimal amt;

    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal conTaxRate;

    @UdcName(udcName = "SYSTEM_BASIC:TAX", codePropName = "conTaxRate")
    private String conTaxRateDesc;

    /**
     * 不含税金额
     */
    @ApiModelProperty("不含税金额")
    private BigDecimal notTaxAmt;

    /**
     * 销售负责人Id
     */
    @ApiModelProperty("销售负责人Id")
    private Long saleManUserId;

    /**
     * 销售负责人名称
     */
    @ApiModelProperty("销售负责人名称")
    @UdcName(udcName = "USER", codePropName = "saleManUserId")
    private Long saleManUserName;


    /**
     * 创建人id
     */
    @ApiModelProperty("创建人id")
    private Long createUserId;

    /**
     * 创建人名称
     */
    @ApiModelProperty("创建人名称")
    @UdcName(udcName = "USER", codePropName = "createUserId")
    private String createUserName;

    /**
     * 计划类型
     */
    @ApiModelProperty("计划类型")
    private String planType;

    @ApiModelProperty("计划类型")
    @UdcName(udcName = "PMS:RESOURCE_PLAN:PLAN_TYPE",codePropName ="planType" )
    private String planTypeDesc;

    @ApiModelProperty("资源规划最新更新日期")
    private LocalDateTime modifyTime;

    @ApiModelProperty("计划对象")
    private String objName;

}
