package com.elitesland.tw.tw5.api.common.funConfig.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypeUploadRecordPayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypeUploadRecordQuery;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypeUploadRecordVO;

import java.util.List;

/**
 * 通用文档-文档上传标记
 *
 * @author duwh
 * @date 2023-12-22
 */
public interface BusinessDocTypeUploadRecordService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessDocTypeUploadRecordVO}>
     */
    PagingVO<BusinessDocTypeUploadRecordVO> queryPaging(BusinessDocTypeUploadRecordQuery query);

    Long count(BusinessDocTypeUploadRecordQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessDocTypeUploadRecordVO}>
     */
    List<BusinessDocTypeUploadRecordVO> queryListDynamic(BusinessDocTypeUploadRecordQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessDocTypeUploadRecordVO}
     */
    BusinessDocTypeUploadRecordVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessDocTypeUploadRecordVO}
     */
    BusinessDocTypeUploadRecordVO insert(BusinessDocTypeUploadRecordPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessDocTypeUploadRecordVO}
     */
    BusinessDocTypeUploadRecordVO update(BusinessDocTypeUploadRecordPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BusinessDocTypeUploadRecordPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
