package com.elitesland.tw.tw5.api.log.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.List;

/**
* 日志记录
*
* @author duwh
* @date 2023-02-03
*/
@Getter
@Setter
public class LogQuery extends TwQueryParam{
    /** 日志类型 ERROR INFO 精确 */
    @Query
    private String logType;
    /** 方法路径 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String method;
    /** 参数 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String params;
    /** ip来源 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String requestIp;
    /** 请求所属地址 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String address;
    /** 浏览器 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String browser;
    /** 异常详情 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String exceptionDetail;
    /** 耗时 BETWEEN */
    @Query(type = Query.Type.BETWEEN)
    private List<Long> time;

    /**
     * 创建者
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String creator;

    /**
     * 创建时间起
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Query(type = Query.Type.GREATER_THAN)
    private LocalDateTime createTimeStart;

    /**
     * 创建时间止
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Query(type = Query.Type.LESS_THAN)
    private LocalDateTime createTimeEnd;
}
