package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;

/**
 * @Author carl.wang
 * @Description 商机案情分析
 * @Date
 **/

@Data

public class CrmOpportunityAnalyzePayload extends TwCommonPayload {
    /**
     * 商机ID
     */
    private Long oppoId;
    /**
     * 负责人ID
     */
    private Long manageUserId;
    /**
     * 具体行动
     */
    private String actionDesc;
    /**
     * 核心关注点
     */
    private String concernDesc;
    /**
     * 竞争优势
     */
    private String advantage;
    /**
     * 对策
     */
    private String treatment;
    /**
     * 案情日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate analyzeDate;

    private Long analyzeIdV4;

    private Long oppoIdV4;

    private Long manageUserIdV4;

}
