package com.elitesland.tw.tw5.api.prd.crm.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;


/**
 * 商机成单率计算指标
 *
 * @author likunpeng
 * @date 2023-11-03
 */
@Getter
@Setter
public class CrmOpportunityMeasureVO extends BaseViewModel implements Serializable {
    /**
     * 商机数据源字段表ID
     */
    @ApiModelProperty("商机数据源字段表ID")
    private Long dataSourceFieldsId;
    /**
     * 商机表字段
     */
    @ApiModelProperty("商机表字段")
    private String oppoTableFields;
    /**
     * 商机表字段
     */
    @ApiModelProperty("商机表字段")
    private String oppoTableFieldsName;
    /**
     * 指标类型
     */
    @ApiModelProperty("指标类型")
    private String indicatorType;
    /**
     * 权重
     */
    @ApiModelProperty("权重")
    private BigDecimal weights;
    /**
     * 系统选择项key
     */
    @ApiModelProperty("系统选择项key")
    private String selectionKey;
    /**
     * 详情
     */
    @ApiModelProperty("详情")
    private List<CrmOpportunityMeasureDVO> crmOpportunityMeasureDVOS;
}
