package com.elitesland.tw.tw5.api.prd.inv.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 发票明细表
 *
 * @author zoey
 * @date 2023-12-05
 */
@Getter
@Setter
public class InvInvoiceDetailPayload extends TwCommonPayload  implements Serializable {
    /** 发票ID */
    @ApiModelProperty("发票ID")
    private Long invId;
    /** 百望系统发票ID */
    @ApiModelProperty("百望系统发票ID")
    private Long baiwangInvId;
    /** 百望系统发票明细表ID */
    @ApiModelProperty("百望系统发票明细表ID")
    private Long baiwangId;
    /** 行号:通用行号 */
    @ApiModelProperty("行号:通用行号")
    private String rowNo;
    /** 商品编码:通用商品编码 */
    @ApiModelProperty("商品编码:通用商品编码")
    private String commodityCode;
    /** 货物或应税劳务名称:1.专普电/通行费:货物或应税劳务、服务名称；2.卷票:项目 */
    @ApiModelProperty("货物或应税劳务名称:1.专普电/通行费:货物或应税劳务、服务名称；2.卷票:项目")
    private String commodityName;
    /** 规格型号:专普电（不含通行费） */
    @ApiModelProperty("规格型号:专普电（不含通行费）")
    private String specificationModel;
    /** 单位:单位 */
    @ApiModelProperty("单位:单位")
    private String unit;
    /** 数量:数量 */
    @ApiModelProperty("数量:数量")
    private BigDecimal quantity;
    /** 单价:单价 */
    @ApiModelProperty("单价:单价")
    private BigDecimal unitPrice;
    /** 金额:金额 */
    @ApiModelProperty("金额:金额")
    private BigDecimal amount;
    /** 税率:税率 */
    @ApiModelProperty("税率:税率")
    private BigDecimal taxRate;
    /** 税额:税额 */
    @ApiModelProperty("税额:税额")
    private BigDecimal tax;
    /** 通行日期起:通行日期起yyyy-MM-ddHH:mm:ss */
    @ApiModelProperty("通行日期起:通行日期起yyyy-MM-ddHH:mm:ss")
    private String currentDateStart;
    /** 通行日期止:通行日期止yyyy-MM-ddHH:mm:ss */
    @ApiModelProperty("通行日期止:通行日期止yyyy-MM-ddHH:mm:ss")
    private String currentDateEnd;
    /** 车牌号:车牌号 */
    @ApiModelProperty("车牌号:车牌号")
    private String licensePlateNum;
    /** 类型:类型，明细中的类型，商品类型 */
    @ApiModelProperty("类型:类型，明细中的类型，商品类型")
    private String goodsType;
    /** 类型:类型，明细中的类型，商品类型 */
    @ApiModelProperty("类型:类型，明细中的类型，商品类型")
    private Integer detailType;
    /** 特殊政策标记:特殊政策标记 0、正常票 1、免税 ，2 不征税 3零税率 */
    @ApiModelProperty("特殊政策标记:特殊政策标记 0、正常票 1、免税 ，2 不征税 3零税率")
    private Integer specialMark;
    /** 是否删除:是否删除，0-否，1-是 */
    @ApiModelProperty("是否删除:是否删除，0-否，1-是")
    private Integer isDel;
}
