package com.elitesland.tw.tw5.api.prd.inv.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.inv.payload.InvInvoiceDocRefPayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceDocRefQuery;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceDocRefVO;

import java.util.List;

/**
 * 发票单据关联管理
 *
 * @author sunxw
 * @date 2023-12-06
 */
public interface InvInvoiceDocRefService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link InvInvoiceDocRefVO}>
     */
    PagingVO<InvInvoiceDocRefVO> queryPaging(InvInvoiceDocRefQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link InvInvoiceDocRefVO}>
     */
    List<InvInvoiceDocRefVO> queryListDynamic(InvInvoiceDocRefQuery query);

    /**
     * 根据单据明细ID和类型获取发票ID
     *
     * @param docDtlId
     * @param docType
     * @return
     */
    List<Long> queryByDtlIdAndType(Long docDtlId, String docType);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link InvInvoiceDocRefVO}
     */
    InvInvoiceDocRefVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link InvInvoiceDocRefVO}
     */
    InvInvoiceDocRefVO insert(InvInvoiceDocRefPayload payload);

    /**
     * 批量插入
     *
     * @param payloads
     * @return
     */
    long batchInsert(List<InvInvoiceDocRefPayload> payloads);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link InvInvoiceDocRefVO}
     */
    InvInvoiceDocRefVO update(InvInvoiceDocRefPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(InvInvoiceDocRefPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 根据单据id和类型删除
     *
     * @param docId
     * @param docType
     */
    void delByDocIdAndType(Long docId, String docType);

}
