package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.ProjShPayload;
import com.elitesland.tw.tw5.api.prd.my.query.ProjShQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.ProjShVO;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 项目成员
 *
 * @author duh
 * @date 2022-12-16
 */
public interface ProjShService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link ProjShVO}>
     */
    PagingVO<ProjShVO> paging(ProjShQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link ProjShVO}>
     */
    List<ProjShVO> queryList(ProjShQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link ProjShVO}
     */
    ProjShVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link ProjShVO}
     */
    ProjShVO insert(ProjShPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link ProjShVO}
     */
    ProjShVO update(ProjShPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * Excel导出数据
     *
     * @param all      待导出的数据
     * @param response /
     * @throws IOException /
     */
    void download(List<ProjShVO> all, HttpServletResponse response) throws IOException;
}
