package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetBiweeklyDetailPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetBiweeklyDetailQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetBiweeklyDetailVO;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 双周计划明细
 *
 * @author duwh
 * @date 2022-12-21
 */
public interface TimesheetBiweeklyDetailService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TimesheetBiweeklyDetailVO}>
     */
    PagingVO<TimesheetBiweeklyDetailVO> paging(TimesheetBiweeklyDetailQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TimesheetBiweeklyDetailVO}>
     */
    List<TimesheetBiweeklyDetailVO> queryList(TimesheetBiweeklyDetailQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TimesheetBiweeklyDetailVO}
     */
    TimesheetBiweeklyDetailVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TimesheetBiweeklyDetailVO}
     */
    TimesheetBiweeklyDetailVO insert(TimesheetBiweeklyDetailPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TimesheetBiweeklyDetailVO}
     */
    TimesheetBiweeklyDetailVO update(TimesheetBiweeklyDetailPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * Excel导出数据
     *
     * @param all      待导出的数据
     * @param response /
     * @throws IOException /
     */
    void download(List<TimesheetBiweeklyDetailVO> all, HttpServletResponse response) throws IOException;

    /**
     * 根据主表id集合 逻辑删除数据
     *
     * @param tsbIds 双周计划主键集合
     * @param type   类型
     */
    void deleteSoftByTsbIds(List<Long> tsbIds, String type);
}
