package com.elitesland.tw.tw5.api.prd.org.service;

import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PersonResPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonEntryCheckVO;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeeRefPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgTenantEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeLeaderQuery;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemUserRoleVO;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface PrdOrgEmployeeService {

    /**
     * 新增
     *
     * @param payload 单据数据
     */
    PrdOrgEmployeeVO insert(PrdOrgEmployeePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     */
    Long update(PrdOrgEmployeePayload payload);

    /**
     * 修改组织关系
     *
     * @param payloads 单据数据
     */
    Long updateEmployeeRef(List<PrdOrgEmployeeRefPayload> payloads);

    /**
     * 查询员工列表
     *
     * @return
     */
    List<PrdOrgEmployeeVO> queryList(PrdOrgEmployeeQuery query);

    /**
     * 查询员工详情
     *
     * @return
     */
    PrdOrgEmployeeVO queryByKey(Long key);


    /**
     * 查询员工详情
     *
     * @return
     */
    PrdOrgEmployeeVO queryByUserId(Long userId);


    /**
     * 查询员工详情
     *
     * @return
     */
    List<PrdOrgEmployeeVO> queryByUserIdIn(List<Long> userId);

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<PrdOrgEmployeeVO> paging(PrdOrgEmployeeQuery query);

    /**
     * 员工逻辑删除
     *
     * @param keys 主键
     * @return result
     */
    boolean deleteSoft(List<Long> keys);

    /**
     * 重置密码
     *
     * @param employeeId 被操作人id
     */
    boolean resetEmployeePawword(Long employeeId);

    /**
     * 批量导出excel
     *
     * @param response 请求响应
     * @param query    查询条件
     */
    void downloadPlus(HttpServletResponse response, PrdOrgEmployeeQuery query);

    /**
     * 批量立项导入excel
     *
     * @param file 请求响应
     */
    boolean importEmployees(MultipartFile file);

    /**
     * 移除员工组织
     *
     * @param employeeId 员工id
     * @param orgIds     组织ids
     * @return result
     */
    boolean deleteOrgRefSoft(Long employeeId, List<Long> orgIds);

    /**
     * 移除员工组织包括默认组织
     *
     * @param employeeId 员工id
     * @param orgIds     组织ids
     * @return result
     */
    boolean deleteOrgRefSoftAll(Long employeeId,LocalDate date);

    /**
     * 更新企业微信id
     *
     * @param userIds
     * @return result
     */
    boolean updateWecomId(List<Long> userIds);

    /**
     * 解绑企业微信id
     *
     * @param userIds
     * @return result
     */
    boolean unbindWecomId(List<Long> userIds);


    /**
     * 获取4.0和5.0用户对应关系Map
     *
     * @return
     */
    Map<Long, Long> getV4AndV5UserIds();

    /**
     * 获取所有上级userIds
     *
     * @param userId
     * @return
     */
    Set<Long> queryParentIdsByUserId(Long userId);
//    /**
//     * 全局更新企业微信id
//     *
//     * @return result
//     */
//    boolean updateAllWecomId();

    /**
     * 通过租户新增
     *
     * @param payload 单据数据
     */
    PrdOrgEmployeeVO saveTenantUser(PrdOrgTenantEmployeePayload payload);

    /**
     * 查询用户角色
     *
     * @param userId
     * @return
     */
    List<String> queryUserRole(Long userId);

    /**
     * 查询用户角色
     *
     * @param userIdList
     * @return
     */
    List<PrdSystemUserRoleVO> queryUserListRole(List<Long> userIdList, List<String> roleCodeList);

    /**
     * 获取企业微信用户信息
     *
     * @param authToken
     */
    ApiResult<OAuthToken> wxLogin(String authToken);

    /**
     * 获取uuid
     *
     * @return
     */
    String getUserUUid();

    /**
     * 绑定企业微信id
     *
     * @param uuid
     */
    Map<String, Object> bindWecomId(String uuid);

    /**
     * 加入黑名单
     *
     * @param id
     * @return
     */
    void updateBlackList(Long id);

    /**
     * 新增资源
     *
     * @param payload
     * @return
     */
    PrdOrgEmployeeVO insertNew(PrdOrgEmployeePayload payload);


    /**
     * 修改资源
     *
     * @param payload
     * @return
     */
    Long updateNew(PersonResPayload payload);

//    /**
//     * 个人信息变更
//     *
//     * @param payload
//     * @return
//     */
//    Long updatePersonalInfo(PersonResPayload payload);
//
//    /**
//     * 查询资源变更信息对比
//     *
//     * @param procId
//     * @return
//     */
//    PersonResChangeVO personalChangeInfo(String procId);

    /**
     * 查询入职检查项信息
     *
     * @param personId
     * @return
     */
    PersonEntryCheckVO entryInfoCheck(Long personId);

    /**
     * 查询所有下级数据
     *
     * @param orgId
     * @param userId
     * @return
     */
    List<PrdOrgEmployeeRefVO> queryLowerUserList(Long orgId, Long userId);

    /**
     * 分页查询 用户与角色一一对应
     *
     * @param query
     * @return
     */
    PagingVO<PrdOrgEmployeeVO> pagingRole(PrdOrgEmployeeQuery query);

    /**
     * 通过维度id查询维度下用户所有直属上级数据
     *
     * @param dimensionId
     * @param userId
     * @return
     */
    List<PrdOrgEmployeeRefVO> queryParentUsers(Long dimensionId, Long userId);

    /**
     * 查询用户下级数据
     *
     * @param orgId
     * @param userId
     * @return
     */
    List<PrdOrgEmployeeRefVO> queryLowListByKey(Long orgId, Long userId);

    /**
     * 查询用户下级下级。。。数据
     *
     * @param orgId
     * @param userId
     * @return
     */
    List<PrdOrgEmployeeRefVO> queryLowChildListByKey(Long orgId, Long userId);

    /**
     * 通过维度id查询维度下用户所有上级数据（包含上级的上级。。。）
     *
     * @param dimensionId
     * @param userId
     * @return
     */
    List<PrdOrgEmployeeRefVO> queryAllParentUsers(Long dimensionId, Long userId);

    /**
     * 查询下级 （直属下级）
     *
     * @param userId 用户id
     * @return {@link Set}<{@link Long}>
     */
    Set<Long> queryOneSubordinatesIdsByUserId(Long userId);

    PrdOrgEmployeeRefVO queryEmployeeRef(Long userId);

    /**
     * 查找上级 （直属上级）
     *
     * @param userIds 用户id
     * @return {@link Set}<{@link Long}>
     */
    Set<Long> queryParentIdByIds(List<Long> userIds);

    /**
     * 根据入职日期查找
     *
     * @param localDate3
     * @return
     */
    List<PrdOrgEmployeeVO> queryByEnrollDate(LocalDate localDate3);

    /**
     * 查询员工的所有组织关系
     *
     * @param userId
     * @return
     */
    List<PrdOrgEmployeeRefVO> queryAllOrgRefByUserId(Long userId);
}
