package com.elitesland.tw.tw5.api.prd.partner.common.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 业务伙伴-账户信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Getter
@Setter
public class BookAccountPayload extends TwCommonPayload implements Serializable {
    /**
     * 地址薄id
     */
    @ApiModelProperty("地址薄id")
    private Long bookId;
    /**
     * 业务伙伴主键（客户主表） business_partner.id
     */
    @ApiModelProperty("业务伙伴主键（客户主表） business_partner.id")
    private Long partnerId;
    /**
     * 账户类型 udc[prd:ab:account_type]
     */
    @ApiModelProperty("账户类型 udc[prd:ab:account_type]")
    private String accountType;

    /**
     * 账户用途 udc[prd:ab:account_usage]
     */
    @ApiModelProperty("账户用途 udc[prd:ab:account_usage]")
    private String accountUsage;
    /**
     * 银行 udc[prd:ab:bank_name]
     */
    @ApiModelProperty("银行 udc[prd:ab:bank_name]")
    private String depositBank;
    /**
     * 开户地
     */
    @ApiModelProperty("开户地")
    private String depositCity;
    /**
     * 开户网点
     */
    @ApiModelProperty("开户网点")
    private String depositBankOutlet;
    /**
     * 户名
     */
    @ApiModelProperty("户名")
    private String accountName;
    /**
     * 账户号
     */
    @ApiModelProperty("账户号")
    private String accountNo;
    /**
     * 币种 udc[SYSTEM_BASIC:CURRENCY]
     */
    @ApiModelProperty("币种 udc[SYSTEM_BASIC:CURRENCY]")
    private String currency;
    /**
     * 是否为默认账户
     */
    @ApiModelProperty("是否为默认账户 ")
    private Boolean isDefault;
    /**
     * 是否需要操作记录
     */
    @ApiModelProperty("是否需要操作记录")
    private Boolean logFlag;
}
