package com.elitesland.tw.tw5.api.prd.pms.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;

/**
 * 项目结项
 *
 * @author xxb
 * @date 2023-11-27
 */
@Getter
@Setter
public class PmsProjectConclusionPayload extends TwCommonPayload implements Serializable {
    /**
     * 异常结项标记
     */
    @ApiModelProperty("异常结项标记")
    private Integer abnormalFlag;
    /**
     * 结项状态
     */
    @ApiModelProperty("结项状态")
    private String conclusionStatus;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 提交资源userid
     */
    @ApiModelProperty("提交资源userid")
    private Long applyUserId;
    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    /**
     * 结项检查事项
     */
    @ApiModelProperty("结项检查事项")
    private String conclusionCheckItems;
    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projId;
    /**
     * 结项编号
     */
    @ApiModelProperty("结项编号")
    private String conclusionCode;


    @ApiModelProperty("节点操作详情")
    private String approvalNodeInfo;

    @ApiModelProperty("提交标记")
    private Boolean submitFlag = false;

    /**
     * 结项审批节点
     */
    @ApiModelProperty("结项审批节点")
    private String approvalNode;

    @ApiModelProperty("检查项配置Payload列表")
    private List<PmsInspectionItemPayload> inspectionItemConfigPayloadList;


    /**
     * 子合同编号
     */
    @ApiModelProperty("子合同编号")
    private String contractNo;

    /**
     * 项目编号
     */
    @ApiModelProperty("项目编号")
    private String projNo;




}
