package com.elitesland.tw.tw5.api.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectEventLogPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectEventLogQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectEventLogVO;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 项目事件日志功能管理
 *
 * @author carl
 * @date 2023-09-18
 */
public interface PmsProjectEventLogService {
    /**
     * 新增或修改
     *
     * @param payload 单据数据
     * @return {@link PmsProjectEventLogVO}
     */
    PmsProjectEventLogVO insertOrUpdate(PmsProjectEventLogPayload payload);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsProjectEventLogVO}>
     */
    PagingVO<PmsProjectEventLogVO> queryPaging(PmsProjectEventLogQuery query);

    /**
     * 事件推送分页列表
     *
     * @return {@link PagingVO}<{@link PmsProjectEventLogVO}>
     */
    PagingVO<PmsProjectEventLogVO> queryPushPaging(PmsProjectEventLogQuery query);


    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsProjectEventLogVO}
     */
    PmsProjectEventLogVO queryByKey(Long key);


    /**
     * 修改状态
     *
     * @param id
     * @return {@link PmsProjectEventLogVO}
     */
    long updateStatus(Long id);


    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 导出模板excel
     *
     * @param response 请求响应
     */
    void downloadPlus(HttpServletResponse response);


    /**
     * 导出功能
     *
     * @param query
     * @param response
     */
    void exportExcel(PmsProjectEventLogQuery query, HttpServletResponse response);

    /**
     * 批量导入excel
     *
     * @param file 请求响应
     */
    boolean importEmployees(MultipartFile file, Long projectId);
}
