package com.elitesland.tw.tw5.api.prd.purchase.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * 采购协议关联资源
 *
 * @author lemon
 * @date 2023-11-02
 */
@Getter
@Setter
public class PurchaseAgreementResPayload extends TwCommonPayload  implements Serializable {
    /** 资源ID */
    @ApiModelProperty("资源ID")
    private Long resId;
    /** 采购协议单据ID */
    @ApiModelProperty("采购协议单据ID")
    private Long documentId;
    /** 采购协议单据编号 */
    @ApiModelProperty("采购协议单据编号")
    private String documentNo;
    /** 资源开始日期 */
    @ApiModelProperty("资源开始日期")
    private LocalDate resStartDate;
    /** 资源结束日期 */
    @ApiModelProperty("资源结束日期")
    private LocalDate resEndDate;
}
