package com.elitesland.tw.tw5.api.prd.purchase.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 采购合同管理
 *
 * @author lipengfei
 * @date 2023-05-30
 */
@Getter
@Setter
public class PurchasePaymentPlanPayload extends TwCommonPayload  implements Serializable {
    /** 付款阶段 */
    @ApiModelProperty("付款阶段")
    private String paymentStage;
    /** 付款金额 */
    @ApiModelProperty("付款金额")
    private BigDecimal paymentAmt;
    /** 本次付款金额 */
    @ApiModelProperty("本次付款金额")
    private BigDecimal currentPaymentAmt;
    /** 付款比例 */
    @ApiModelProperty("付款比例")
    private BigDecimal paymentProportion;
    /** 预计付款日期 */
    @ApiModelProperty("预计付款日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate estimatedPaymentDate;
    /** 付款申请单号 */
    @ApiModelProperty("付款申请单号")
    private Long paymentApplyId;
    /** 单据id */
    @ApiModelProperty("单据id")
    private Long contractId;
    /** 单据编号 */
    @ApiModelProperty("单据编号")
    private String contractNo;
    /** 付款状态 */
    @ApiModelProperty("付款状态")
    private String paymentStatus;
    /** 核销状态 */
    @ApiModelProperty("核销状态")
    private String writeoffStatus;
    /** 约束里程碑 */
    @ApiModelProperty("约束里程碑")
    private Long milestone;
    /** 单据类型 */
    @ApiModelProperty("单据类型")
    private String docType;
    /** 付款时间 */
    @ApiModelProperty("付款时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDateTime paymentDate;
    /** 约束合同节点 */
    @ApiModelProperty("约束合同节点")
    private Long contractNode;
    /** 预付款中付款计划id */
    private Long prePaymentPlanId;
}
