package com.elitesland.tw.tw5.api.prd.purchase.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 采购合同管理
 *
 * @author lipengfei
 * @date 2023-05-30
 */
@Getter
@Setter
public class PurchasePaymentPlanQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 付款阶段 精确 */
    @ApiModelProperty("付款阶段")
    private String paymentStage;
    /** 付款金额 精确 */
    @ApiModelProperty("付款金额")
    private BigDecimal paymentAmt;
    /** 本次付款金额 精确 */
    @ApiModelProperty("本次付款金额")
    private BigDecimal currentPaymentAmt;
    /** 付款比例 精确 */
    @ApiModelProperty("付款比例")
    private BigDecimal paymentProportion;
    /** 预计付款日期 精确 */
    @ApiModelProperty("预计付款日期")
    private LocalDate estimatedPaymentDate;
    /** 付款申请单号 精确 */
    @ApiModelProperty("付款申请单号")
    private Long paymentApplyId;
    /** 单据id 精确 */
    @ApiModelProperty("单据id")
    private Long contractId;
    /** 单据编号 精确 */
    @ApiModelProperty("单据编号")
    private String contractNo;
    /** 付款状态 精确 */
    @ApiModelProperty("付款状态")
    private String paymentStatus;
    /** 核销状态 精确 */
    @ApiModelProperty("核销状态")
    private String writeoffStatus;
    /** 约束里程碑 精确 */
    @ApiModelProperty("约束里程碑")
    private Long milestone;
    /** 单据类型 精确 */
    @ApiModelProperty("单据类型")
    private String docType;
    /** 付款时间 精确 */
    @ApiModelProperty("付款时间")
    private LocalDateTime paymentDate;
    /** 约束合同节点 精确 */
    @ApiModelProperty("约束合同节点")
    private Long contractNode;
}
