package com.elitesland.tw.tw5.api.prd.purchase.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseAgreementPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseAgreementQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentDefaultVO;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;

/**
 * 采购协议
 *
 * @author Echo
 * @date 2023-06-08
 */
public interface PurchaseAgreementService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PurchaseAgreementVO}>
     */
    PagingVO<PurchaseAgreementVO> queryPaging(PurchaseAgreementQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PurchaseAgreementVO}>
     */
    List<PurchaseAgreementVO> queryListDynamic(PurchaseAgreementQuery query);

//    /**
//     * @return
//     * @Description 签约公司/供应商-列表查询
//     **/
//    List<PrdAbVO> abQueryList(String relateType);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PurchaseAgreementVO}
     */
    PurchaseAgreementVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PurchaseAgreementVO}
     */
    PurchaseAgreementVO insert(PurchaseAgreementPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PurchaseAgreementVO}
     */
    PurchaseAgreementVO update(PurchaseAgreementPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PurchaseAgreementPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 逻辑删除
     *
     * @param id 主键
     */
    void active(Long id);

    /**
     * 暂挂
     * @param ids
     */
    void pending(List<Long> ids);

    /**
     * 终止
     */
    void purAgreementBreak(List<Long> ids, String overReason);

    /**
     * 批量导出协议excel
     *
     * @param response 请求响应
     * @param query    查询条件
     */
    void download(HttpServletResponse response, PurchaseAgreementQuery query);

    /**
     * 权限-批量导出协议excel
     * @param query 查询条件
     */
    void permissionDownload(PurchaseAgreementQuery query, HttpServletResponse response);

    /**
     * 通过采购协议编号查询付款申请单前置数据
     * @param docNo 合同编号
     * @return 付款申请单前置数据
     */
    PurchasePaymentDefaultVO findPaymentDefaultByDocNo(String docNo);

    /**
     * 通过协议编号查询协议Id
     * @param docNo 协议编号
     * @return 协议Id
     */
    Long findIdByNo(String docNo);


    /**
     * 通过协议编号查询协议详情 目前只查询金额
     * @param docNo 协议编号
     * @return PurchaseAgreementVO 详情
     */
    PurchaseAgreementVO queryByNo(String docNo);

    /**
     * 根据采购协议ID获取费率（返回值为数字，如需计算需要÷100）
     * @param agreementId 采购协议Id
     * @param amt 总金额
     * @return 费率
     */
    BigDecimal getRateByAgreementId(Long agreementId, BigDecimal amt);

    /**
     * 采购协议-权限分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PurchaseAgreementVO}>
     */
    PagingVO<PurchaseAgreementVO> permissionPaging(PurchaseAgreementQuery query);
}
