package com.elitesland.tw.tw5.api.prd.salecon.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivablePayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivableQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivableVO;

import java.util.List;

/**
 * 合同收款
 *
 * @author lemon
 * @date 2023-08-31
 */
public interface ConReceivableService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link ConReceivableVO}>
     */
    PagingVO<ConReceivableVO> queryPaging(ConReceivableQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link ConReceivableVO}>
     */
    List<ConReceivableVO> queryListDynamic(ConReceivableQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link ConReceivableVO}
     */
    ConReceivableVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link ConReceivableVO}
     */
    int insert(ConReceivablePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link ConReceivableVO}
     */
    ConReceivableVO update(ConReceivablePayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(ConReceivablePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 更新收款表银行账号、总账日期
     *
     * @param invId      开票记录id
     * @param accountNo  银行账号
     * @param ledgerDate 总账日期
     * @return 更新记录数
     */
    Integer updateRecvAccount(Long invId, String accountNo, String ledgerDate);

    /**
     * 同步4.0
     * @param param
     */
    @Deprecated
    void syncConReceivableTo4(String param);
}
