package com.elitesland.tw.tw5.api.prd.salecon.service;

import com.elitesland.tw.tw5.api.prd.salecon.payload.ConServicePricePayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConServicePriceQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConServicePriceVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 销售合同-T&M-服务价格
 *
 * @author sam.li
 * @date 2024-05-07
 */
public interface ConServicePriceService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link ConServicePriceVO}>
     */
    PagingVO<ConServicePriceVO> queryPaging(ConServicePriceQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link ConServicePriceVO}>
     */
    List<ConServicePriceVO> queryListDynamic(ConServicePriceQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link ConServicePriceVO}
     */
    ConServicePriceVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link ConServicePriceVO}
     */
    ConServicePriceVO insert(ConServicePricePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link ConServicePriceVO}
     */
    ConServicePriceVO update(ConServicePricePayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(ConServicePricePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 通过合同id更新结算周期和方式
     *
     * @param saleConId 合同id
     * @param settlementCycle 结算周期
     * @param settlementMethod 结算方式
     */
    void updateBySaleConId(Long saleConId, String settlementCycle, String settlementMethod);

}
