package com.elitesland.tw.tw5.api.prd.schedule.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

/**
 * @author zoey
 * @Description:
 * @date 2022/4/20 - 20:19
 */
@Data
public class PrdScheduleQuery extends TwQueryParam {
    @ApiModelProperty("日程标题")
    private String title;

    @ApiModelProperty("日程描述")
    private String description;

    @ApiModelProperty("日程地址")
    private String location;

    @ApiModelProperty("全天")
    private Integer allDay;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("开始时间")
    private LocalDateTime startTime;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty("日历id")
    private Long calId;

    @ApiModelProperty("日历id集合，逗号分隔")
    private String calIds;

    @ApiModelProperty("是否允许非参与人主动加入日程")
    private Integer allowActiveJoin;

    @ApiModelProperty("是否重复")
    private Integer isRepeat;

    @ApiModelProperty("是否提醒")
    private Integer isRemind;

    @ApiModelProperty("提前发送提醒时间")
    private Integer remindBeforeEventSecs;
}
