package com.elitesland.tw.tw5.api.prd.task.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 任务
 *
 * @author xxb
 * @date 2023-11-16
 */
@Getter
@Setter
public class TaskPackageVO extends BaseViewModel implements Serializable {

    @ApiModelProperty("事由id")
    private Long reasonId;
    @ApiModelProperty("事由名称")
    private String reasonName;
    @ApiModelProperty("事由类型 01 项目 02 售前 03 bu")
    private String reasonType;
    @UdcName(udcName = "PMS:PROJECT:TYPE", codePropName = "reasonType")
    private String reasonTypeDesc;

    @ApiModelProperty(value = "任务包编号")
    private String taskPackageNo;


    /**
     * 任务包名称
     */
    @ApiModelProperty(value = "任务包名称")
    private String taskPackageName;

    /**
     * 发包资源id
     */
    @ApiModelProperty(value = "发包资源id")
    private Long disterResId;
    @UdcName(udcName = "USER", codePropName = "disterResId")
    @ApiModelProperty(value = "发包资源")
    private String disterResName;

    /**
     * 接收资源id
     */
    @ApiModelProperty(value = "接收资源id")
    private Long receiverResId;
    @UdcName(udcName = "USER", codePropName = "receiverResId")
    @ApiModelProperty(value = "接收资源")
    private String receiverResName;

    @ApiModelProperty("当量系数")
    private BigDecimal eqvaRatio;

    /**
     * 接收资源复合能力ID
     */
    @ApiModelProperty(value = "接收资源复合能力ID")
    private Long compositeAbilityId;
    @ApiModelProperty(value = "接收资源复合能力")
    private String compositeAbilityName;

    /**
     * 任务包开始日期
     */
    @ApiModelProperty(value = "任务包开始日期")
    private LocalDate startDate;

    /**
     * 任务包结束日期
     */
    @ApiModelProperty(value = "任务包结束日期")
    private LocalDate endDate;

    /**
     * 任务包状态
     */
    @ApiModelProperty(value = "任务包状态")
    private String taskPackageStatus;
    @UdcName(udcName = "PMS:TASK:STATUS", codePropName = "taskPackageStatus")
    private String taskPackageStatusDesc;

    /**
     * 任务包类型
     */
    @ApiModelProperty(value = "任务包类型")
    private String taskPackageType;
    @UdcName(udcName = "TSK:TASK_PACKAGE_TYPE", codePropName = "taskPackageType")
    private String taskPackageTypeDesc;

    /**
     * 任务包说明
     */
    @ApiModelProperty(value = "任务包说明")
    private String taskPackageDes;

    /**
     * 结算信息
     */

    /**
     * 验收人
     */
    @ApiModelProperty(value = "验收人")
    private Long acceptorId;

    @UdcName(udcName = "USER", codePropName = "acceptorId")
    private String acceptor;

    /**
     * 验收方式
     */
    @ApiModelProperty(value = "验收方式")
    private String acceptMethod;
    @UdcName(udcName = "PMS:TASK:ACCEPT_METHOD", codePropName = "acceptMethod")
    private String acceptMethodName;

    /**
     * 计价方式
     */
    @ApiModelProperty(value = "计价方式")
    private String pricingMethod;
    @UdcName(udcName = "PMS:TASK:PRICING_METHOD", codePropName = "pricingMethod")
    private String pricingMethodName;

    /**
     * 定时任务自动结算当量标记
     */
    @ApiModelProperty(value = "定时任务自动结算当量标记")
    private Integer autoSettleFlag;

    /**
     * 质保金比例
     */
    @ApiModelProperty(value = "质保金比例")
    private BigDecimal guaranteeRate;

    /**
     * 当量结算单价
     */
    @ApiModelProperty(value = "当量结算单价")
    private BigDecimal settlePrice;

    /**
     * 当量收入单价
     */
    @ApiModelProperty(value = "当量收入单价")
    private BigDecimal incomePrice;

    /**
     * 总当量
     */
    @ApiModelProperty(value = "总当量")
    private BigDecimal totalEqva;

    /**
     * 总金额
     */
    @ApiModelProperty(value = "总金额")
    private BigDecimal totalAmt;


    /**
     * 工种
     */
    @ApiModelProperty("工种")
    private String jobType1;

    /**
     * 工种子类
     */
    @ApiModelProperty("工种子类")
    private String jobType2;

    /**
     * 接收资源bu_id
     */
    @ApiModelProperty("接收资源bu_id")
    private Long receiverBuId;
    @UdcName(udcName = "BU", codePropName = "receiverBuId")
    private String receiverBuName;

    @ApiModelProperty("任务列表")
    private List<TaskInfoVO> taskInfoVOS;
    /**
     * 是否可以创建任务
     */
    @ApiModelProperty("是否可以创建任务")
    private Boolean createTaskFlag;
}
