package com.elitesland.tw.tw5.api.prd.acc.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;

/**
 * 费用报销记账/付款导出管理
 *
 * @author sunxw
 * @date 2023-12-01
 */
@Getter
@Setter
public class AccReimPayBatchPayload extends TwCommonPayload implements Serializable {
    /**
     * 审批批次编号
     */
    @ApiModelProperty("审批批次编号")
    private String batchNo;
    /**
     * 审批批次名称
     */
    @ApiModelProperty("审批批次名称")
    private String batchName;
    /**
     * 批次生成时间
     */
    @ApiModelProperty("批次生成时间")
    private LocalDateTime batchTime;
    /**
     * 批状态，0正常，1作废
     */
    @ApiModelProperty("批状态，0正常，1作废")
    private String batchStatus;
    /**
     * 批类型 account-财务记账导出，cashier-财务付款导出
     */
    @ApiModelProperty("批类型 account-财务记账导出，cashier-财务付款导出")
    private String batchType;
    /**
     * 数据最后一次导出时间
     */
    @ApiModelProperty("数据最后一次导出时间")
    private LocalDateTime lastExportTime;
    /**
     * 导出次数
     */
    @ApiModelProperty("导出次数")
    private Integer exportCount;
    /**
     * 本批次报销总额
     */
    @ApiModelProperty("本批次报销总额")
    private BigDecimal batchAmt;
    /**
     * 报销批明细条数量
     */
    @ApiModelProperty("报销批明细条数量")
    private Integer batchQty;
}
