package com.elitesland.tw.tw5.api.prd.acc.payload;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author sunxw
 * @description
 * @Date 2023/12/4
 */
@Data
public class AccReimSourceDetailPayload implements Serializable {

    @ApiModelProperty("费用发生日")
    private LocalDate expenseDate;

    @ApiModelProperty("早餐费选择标记 0-未选 1-已选")
    private Integer breakfastFlag;
    @ApiModelProperty("早餐费")
    private BigDecimal breakfastFee;

    @ApiModelProperty("午餐费选择标记 0-未选 1-已选")
    private Integer lunchFeeFlag;
    @ApiModelProperty("午餐费")
    private BigDecimal lunchFee;

    @ApiModelProperty("晚餐费选择标记 0-未选 1-已选")
    private Integer dinnerFeeFlag;
    @ApiModelProperty("晚餐费")
    private BigDecimal dinnerFee;

    /**
     *
     * 非差旅报销报加班费增加以下字段
     *
     **/
    @ApiModelProperty("打卡城市")
    private String city;

    @ApiModelProperty("开始时间")
    private LocalDateTime startTime;

    @ApiModelProperty("结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty("附件")
    private String fileCodes;

    @ApiModelProperty("附件")
    private Object fileDates;

    @ApiModelProperty("餐费")
    private BigDecimal fee;

    @ApiModelProperty("工时状态")
    private String tsStatus;

    @ApiModelProperty("工时状态")
    private Integer tsHour;

}
