package com.elitesland.tw.tw5.api.prd.acc.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 报销金额来源配置管理
 *
 * @author sunxw
 * @date 2023-12-04
 */
@Getter
@Setter
public class AccReimSourceConfigQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 核算项目(对多个生效时，可以,分割) 精确
     */
    @ApiModelProperty("核算项目(对多个生效时，可以,分割)")
    private String busAccItemCodes;
    /**
     * 配置名称 精确
     */
    @ApiModelProperty("配置名称")
    private String configName;
    /**
     * 是否启用 0-否 1-是 精确
     */
    @ApiModelProperty("是否启用 0-否 1-是")
    private Integer enableFlag;
    /**
     * 金额是否必须由计算器得出 0-否 1-是 精确
     */
    @ApiModelProperty("金额是否必须由计算器得出 0-否 1-是")
    private Integer calcFlag;
    /**
     * 配置说明(富文本字段) 精确
     */
    @ApiModelProperty("配置说明(富文本字段)")
    private String configRemark;
    /**
     * 配置类型 INNER-内置制度 HALF-半配置化 ALL-全配置化 精确
     */
    @ApiModelProperty("配置类型 INNER-内置制度 HALF-半配置化 ALL-全配置化")
    private String configType;
}
