package com.elitesland.tw.tw5.api.prd.adm.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;


/**
 * 出差申请明细管理
 *
 * @author carl
 * @date 2023-10-30
 */
@Getter
@Setter
public class AdmBusitripApplyDetailVO extends BaseViewModel implements Serializable {
    /**
     * 申请id
     */
    @ApiModelProperty("申请id")
    private Long applyId;
    /**
     * 出差人资源id
     */
    @ApiModelProperty("出差人资源id")
    private Long tripResId;
    @UdcName(udcName = "USER", codePropName = "tripResId")
    private String tripResName;
    /**
     * 出发地
     */
    @ApiModelProperty("出发地")
    private String fromPlace;
    @UdcName(udcName = "SYSTEM_BASIC:PCD", codePropName = "fromPlace")
    private String fromPlaceDesc;
    /**
     * 目的地
     */
    @ApiModelProperty("目的地")
    private String toPlace;
    @UdcName(udcName = "SYSTEM_BASIC:PCD", codePropName = "toPlace")
    private String toPlaceDesc;
    /**
     * 交通工具
     */
    @ApiModelProperty("交通工具")
    private String vehicle;
    @UdcName(udcName = "ADM:BUSITRIP:VEHICLE", codePropName = "vehicle")
    private String vehicleDesc;
    /**
     * 出发日期
     */
    @ApiModelProperty("出发日期")
    private LocalDate beginDate;
    /**
     * 结束日期
     */
    @ApiModelProperty("结束日期")
    private LocalDate endDate;
    /**
     * 出发时间段
     */
    @ApiModelProperty("出发时间段")
    private String beginTimespan;
    /**
     * 结束时间段
     */
    @ApiModelProperty("结束时间段")
    private String endTimespan;
}
