package com.elitesland.tw.tw5.api.prd.humanresources.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Data
public class ExternalResApplyVO extends BaseViewModel {

    @ApiModelProperty("personId")
    private Long personId;

    @ApiModelProperty("名称")
    private String personName;

    @ApiModelProperty("性别")
    private String sex;

    @ApiModelProperty("手机号")
    private String mobile;

    @ApiModelProperty("资源类型一")
    private String resType1;

    @ApiModelProperty("资源类型一")
    @UdcName(udcName = "org:employee:type", codePropName = "resType1")
    private String resType1Desc;

    @ApiModelProperty("资源类型二")
    private String resType2;

    @ApiModelProperty("资源类型二")
    @UdcName(udcName = "org:employee:type:external", codePropName = "resType2")
    private String resType2Desc;

    @ApiModelProperty("BaseBu")
    private Long orgId;

    @ApiModelProperty("BaseBu名称")
    private String orgName;

    @ApiModelProperty("上级id")
    private Long parentId;

    @ApiModelProperty("合作方式")
    private String cooperationMode;

    @ApiModelProperty("合作方式")
    @UdcName(udcName = "org:employee:COOPERATION_MODE", codePropName = "cooperationMode")
    private String cooperationModeDesc;

    @ApiModelProperty("结算方式")
    private String settleMethod;

    @ApiModelProperty("结算方式")
    @UdcName(udcName = "org:employee:withdrawSettleMethod", codePropName = "settleMethod")
    private String settleMethodDesc;

    @ApiModelProperty("单位当量收入")
    private Double preeqvaAmt;

    @ApiModelProperty("当量系数")
    private BigDecimal eqvaRatio;

    @ApiModelProperty("原资源状态")
    private String oldResStatus;

    @ApiModelProperty("是否开通邮箱")
    private Boolean emailFlag;

    @ApiModelProperty("是否开通E-learning账号")
    private Boolean elpFlag;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("E-learning账号")
    private String elpId;

    @ApiModelProperty("tw账号")
    private String userName;

    @ApiModelProperty("入职类型")
    private String entryType;

    @ApiModelProperty("长期/短期")
    private String periodFlag;

    @ApiModelProperty("预计入场时间")
    private LocalDate expectedStartDate;

    @ApiModelProperty("预计离场时间")
    private LocalDate expectedEndDate;

    @ApiModelProperty("岗位分类一")
    private String jobClass1;

    @ApiModelProperty("岗位分类一")
    @UdcName(udcName = "org:employee:jobType", codePropName = "jobClass1")
    private String jobClass1Desc;


    @ApiModelProperty("岗位分类二")
    private String jobClass2;

    @ApiModelProperty("岗位分类二")
    private String jobClass2Desc;

    @ApiModelProperty("复合能力")
    private Long capasetLevelId;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("申请人")
    private String createUserName;

}
