package com.elitesland.tw.tw5.api.prd.humanresources.vo;

import lombok.Data;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;

import io.swagger.annotations.ApiModel;
import com.elitescloud.boot.common.param.BaseViewModel;


/**
 * @author : WWW
 * @date : 2023-10-27
 * @desc : 员工-复合能力
 */

@Data
@ApiModel(description = "员工-复合能力")
public class PrdEmployeCompositeAbilityVO extends BaseViewModel {


    /**
     * 编号
     */
    @ApiModelProperty("编号")
    private String docNo;

    /**
     * 能力名称
     */
    @ApiModelProperty("能力名称")
    private String abilityName;

    /**
     * 能力id
     */
    @ApiModelProperty("能力id")
    private Long abilityId;

    /**
     * 能力描述
     */
    @ApiModelProperty("能力描述")
    private String abilityDesc;

    /**
     * 主能力
     */
    @ApiModelProperty("主能力")
    private Boolean mainFlag;

    /**
     * 辅能力
     */
    @ApiModelProperty("辅能力")
    private Boolean auxFlag;

    /**
     * 当量系数
     */
    @ApiModelProperty("当量系数")
    private BigDecimal dlRatio;

    /**
     * 获取时间
     */
    @ApiModelProperty("获取时间")
    private LocalDate obtainTime;

    /**
     * 上次认证时间
     */
    @ApiModelProperty("上次认证时间")
    private LocalDate lastCertTime;

    /**
     * 过期时间
     */
    @ApiModelProperty("过期时间")
    private LocalDate expirateTime;

    /**
     * 员工id
     */
    @ApiModelProperty("员工id")
    private Long empId;

    /**
     * 员工名称
     */
    @ApiModelProperty("员工名称")
    private String empName;

    /**
     * 员工编号
     */
    @ApiModelProperty("员工编号")
    private String empDocNo;

    /**
     * 级别定义的名称
     */
    @ApiModelProperty("级别定义的名称")
    private String levelDtlName;


    @ApiModelProperty("能力级别定义id")
    private Long abilityLevelId;
}

