package com.elitesland.tw.tw5.api.prd.my.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.util.List;

@Data
public class UserVacationQuery extends TwQueryParam {

    @ApiModelProperty("userId")
    private Long userId;

    @ApiModelProperty("年度")
    private Long vacationYear;

    @ApiModelProperty("假期类型")
    private String vacationType;

    @ApiModelProperty("组织")
    private Long orgId;

    @ApiModelProperty("主服务地")
    private String extString5;


    @ApiModelProperty("有效期开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate expirationStartDate;


    @ApiModelProperty("有效期开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate expirationEndDate;

    @ApiModelProperty("id集合")
    private List<Long> ids;

    @ApiModelProperty("事由类型")
    private String reasonType;

    @ApiModelProperty("事由号")
    private Long reasonId;

}
