package com.elitesland.tw.tw5.api.prd.partner.team.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 业务伙伴-团队成员
 *
 * @author wangly
 * @date 2023-05-16
 */
@Getter
@Setter
public class BusinessTeamMemberPayload extends TwCommonPayload  implements Serializable {
    /** 业务id */
    @ApiModelProperty("业务id")
    private Long objectId;
    /** 业务类型 */
    @ApiModelProperty("业务类型 udc[CRM:BUSINESS_PARTNER:TEAM_TYPE:PARTNER]")
    private String type;

    /**  用户id */
    @ApiModelProperty(" 用户id")
    private Long userId;
    /** 成员名称 */
    @ApiModelProperty("成员名称")
    private String memberName;
    /** 成员角色 */
    @ApiModelProperty("成员角色")
    private String memberRole;
    /** 成员角色名称 */
    @ApiModelProperty("成员角色名称")
    private String memberRoleName;
    /** 是否为创建者 */
    @ApiModelProperty("是否为创建者")
    private Boolean isCreator;
    /** 组织id */
    @ApiModelProperty("组织id")
    private Long orgId;
    /** 维度id */
    @ApiModelProperty("维度id")
    private Long dimensionId;
    /** 组织改变前ID */
    @ApiModelProperty("组织改变前ID")
    private Long changeId;
    /** 组织名称 */
    @ApiModelProperty("组织名称")
    private String orgName;
    /** 组织编号 */
    @ApiModelProperty("组织编号")
    private String orgCode;
    /** 组织状态 */
    @ApiModelProperty("组织状态")
    private String orgStatus;
    /** 排序号 */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /** 扩展字段1 */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /** 扩展字段2 */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /** 扩展字段3 */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /** 扩展字段4 */
    @ApiModelProperty("扩展字段4")
    private String ext4;
    /** 扩展字段5 */
    @ApiModelProperty("扩展字段5")
    private String ext5;

}
