package com.elitesland.tw.tw5.api.prd.salecon.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 合同收款
 *
 * @author lemon
 * @date 2023-08-31
 */
@Getter
@Setter
public class ConReceivableQuery extends TwQueryParam implements Serializable{
    /**  精确 */
    @ApiModelProperty("")
    private Long id;
    /** 收款批次号 精确 */
    @ApiModelProperty("收款批次号")
    private String recvNo;
    /** 收款类别 发票收款/预收款 精确 */
    @ApiModelProperty("收款类别 发票收款/预收款")
    private String recvClass;
    /** 来源ID 精确 */
    @ApiModelProperty("来源ID")
    private Long sourceId;
    /** 收款金额 精确 */
    @ApiModelProperty("收款金额")
    private BigDecimal recvAmt;
    /** 收款日期 精确 */
    @ApiModelProperty("收款日期")
    private LocalDate recvDate;
    /** 银行账号 精确 */
    @ApiModelProperty("银行账号")
    private String accountNo;
    /** 总账日期 精确 */
    @ApiModelProperty("总账日期")
    private LocalDate ledgerDate;
}
