package com.elitesland.tw.tw5.api.prd.salecon.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;


/**
 * 部门毛利率配置
 *
 * @author wangly
 * @date 2024-04-01
 */
@Getter
@Setter
public class OrgGrossProfitRateSettingVO extends BaseViewModel implements Serializable {
    /**
     * 部门id
     */
    @ApiModelProperty("部门id")
    private Long orgId;

    /**
     * 部门id
     */
    @ApiModelProperty("部门名称")
    @UdcName(udcName = "BU", codePropName = "orgId")
    private Long orgName;
    /**
     * 工作类型 [salecon:work_type]
     */
    @ApiModelProperty("工作类型 [salecon:work_type]")
    private String workType;

    /**
     * 工作类型 [salecon:work_type]
     */
    @ApiModelProperty("工作类型 [salecon:work_type]")
    @UdcName(udcName = "salecon:work_type", codePropName = "workType")
    private String workTypeDesc;
    /**
     * 部门毛利率
     */
    @ApiModelProperty("部门毛利率")
    private BigDecimal orgGrossProfitRate;
    /**
     * 过单毛利率
     */
    @ApiModelProperty("过单毛利率")
    private BigDecimal orderGrossProfitRate;
    /**
     * 开始日期
     */
    @ApiModelProperty("开始日期")
    private LocalDate startDate;
    /**
     * 结束日期
     */
    @ApiModelProperty("结束日期")
    private LocalDate endDate;
    /**
     * 排序号
     */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /**
     * 拓展字段1
     */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /**
     * 拓展字段2
     */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /**
     * 拓展字段3
     */
    @ApiModelProperty("拓展字段3")
    private String ext3;
    /**
     * 拓展字段4
     */
    @ApiModelProperty("拓展字段4")
    private String ext4;
    /**
     * 拓展字段5
     */
    @ApiModelProperty("拓展字段5")
    private String ext5;

    /**
     * 资源经理
     */
    @ApiModelProperty("资源经理")
    private Long resManagerId;

    /**
     * 资源经理
     */
    @ApiModelProperty("资源经理")
    @UdcName(udcName = "USER", codePropName = "resManagerId")
    private String resManagerName;

}
