package com.elitesland.tw.tw5.api.prd.system.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 阶梯毛利率设置
 *
 * @author likunpeng
 * @date 2023-04-03
 */
@Getter
@Setter
public class PrdSystemGrossMarginVO extends BaseViewModel implements Serializable {
    /** BU_ID */
    @ApiModelProperty("BU_ID")
    private Long buId;
    /** BU_Name */
    @UdcName(udcName = "BU", codePropName = "buId")
    private String buName;
    /** 年度 */
    @ApiModelProperty("年度")
    private Integer yearly;
    /** 合同金额 */
    @ApiModelProperty("合同金额")
    private BigDecimal amt;
    /** BU负责人ID */
    @ApiModelProperty("BU负责人ID")
    private Long buDirectorId;
    /**  BU负责人Name */
    @UdcName(udcName = "USER", codePropName = "buDirectorId")
    private String buDirectorName;
    /** BU毛利率 */
    @ApiModelProperty("BU毛利率")
    private Integer buGrossMargin;
    /** 阶梯毛利率1 */
    @ApiModelProperty("阶梯毛利率1")
    private Integer ladderGrossMargin1;
    /** 阶梯负责人1ID */
    @ApiModelProperty("阶梯负责人1ID")
    private Long ladderDirectorId1;
    /**  阶梯负责人1Name */
    @UdcName(udcName = "USER", codePropName = "ladderDirectorId1")
    private String ladderDirectorName1;
    /** 阶梯毛利率2 */
    @ApiModelProperty("阶梯毛利率2")
    private Integer ladderGrossMargin2;
    /** 阶梯负责人2ID */
    @ApiModelProperty("阶梯负责人2ID")
    private Long ladderDirectorId2;
    /**  阶梯负责人1Name */
    @UdcName(udcName = "USER", codePropName = "ladderDirectorId2")
    private String ladderDirectorName2;
}
