package com.elitesland.tw.tw5.api.prd.adm.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmBusitripApplyDetailPayload;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmBusitripApplyDetailQuery;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmBusitripApplyDetailVO;

import java.util.List;

/**
 * 出差申请明细管理
 *
 * @author carl
 * @date 2023-10-30
 */
public interface AdmBusitripApplyDetailService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AdmBusitripApplyDetailVO}>
     */
    PagingVO<AdmBusitripApplyDetailVO> queryPaging(AdmBusitripApplyDetailQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AdmBusitripApplyDetailVO}>
     */
    List<AdmBusitripApplyDetailVO> queryListDynamic(AdmBusitripApplyDetailQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AdmBusitripApplyDetailVO}
     */
    AdmBusitripApplyDetailVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AdmBusitripApplyDetailVO}
     */
    AdmBusitripApplyDetailVO insert(AdmBusitripApplyDetailPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link AdmBusitripApplyDetailVO}
     */
    AdmBusitripApplyDetailVO update(AdmBusitripApplyDetailPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(AdmBusitripApplyDetailPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 批量新增或修改
     *
     * @param payloads 单据数据
     */
    List<AdmBusitripApplyDetailVO> bacthInsert(List<AdmBusitripApplyDetailPayload> payloads);

    /**
     * 根据出差id逻辑删除
     *
     * @param busitripIds 出差id
     */
    void deleteSoftByApplyId(List<Long> busitripIds);

}
