package com.elitesland.tw.tw5.api.prd.humanresources.service;

import java.util.List;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluatePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateVO;

import javax.servlet.http.HttpServletResponse;


/**
 * @author : WWW
 * @date : 2023-11-24
 * @desc : 评价表Service
 */

public interface PrdEvaluateService {

    /**
     * 新增评价表数据
     *
     * @param prdEvaluatePayload
     * @return
     */
    PrdEvaluateVO save(PrdEvaluatePayload prdEvaluatePayload);

    /**
     * 根据主键更新
     *
     * @param prdEvaluatePayload
     * @return
     */
    PrdEvaluateVO update(PrdEvaluatePayload prdEvaluatePayload);

    /**
     * 根据主键获取详情
     *
     * @param id
     * @return
     */
    PrdEvaluateVO get(Long id);

    /**
     * 分页查询列表
     *
     * @param prdEvaluateQuery
     * @return
     */
    PagingVO<PrdEvaluateVO> page(PrdEvaluateQuery prdEvaluateQuery);

    /**
     * 根据主键批量删除
     *
     * @param ids
     * @return
     */
    Long del(List<Long> ids);

    /**
     * 获取列表查询
     *
     * @param prdEvaluateQuery
     * @return
     */
    List<PrdEvaluateVO> getList(PrdEvaluateQuery prdEvaluateQuery);

    /**
     * 根据条件修改
     *
     * @param prdEvaluatePayload
     * @return
     */
    Long updateByCondition(PrdEvaluatePayload prdEvaluatePayload);

    /**
     * 批量保存
     *
     * @param prdEvaluatePayloadList
     * @return
     */
    Boolean batchSave(List<PrdEvaluatePayload> prdEvaluatePayloadList);

    /**
     * 更改状态根据formId
     * @param prdEvaluatePayload
     * @return
     */
    Long updateStateByFormId(PrdEvaluatePayload prdEvaluatePayload);

    /**
     * 获取指定用户/指定评价类型的
     * 评价总记录和总分值
     */
    List<PrdEvaluateVO> getScoreListByUserId(PrdEvaluateQuery prdEvaluateQuery);
}

