package com.elitesland.tw.tw5.api.prd.inv.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.inv.payload.InvInvoiceDetailPayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceDetailQuery;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceDetailVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 发票明细表
 *
 * @author zoey
 * @date 2023-12-05
 */
public interface InvInvoiceDetailService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link InvInvoiceDetailVO}>
     */
    PagingVO<InvInvoiceDetailVO> queryPaging(InvInvoiceDetailQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link InvInvoiceDetailVO}>
     */
    List<InvInvoiceDetailVO> queryListDynamic(InvInvoiceDetailQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link InvInvoiceDetailVO}
     */
    InvInvoiceDetailVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link InvInvoiceDetailVO}
     */
    InvInvoiceDetailVO insert(InvInvoiceDetailPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link InvInvoiceDetailVO}
     */
    InvInvoiceDetailVO update(InvInvoiceDetailPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(InvInvoiceDetailPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
