package com.elitesland.tw.tw5.api.prd.my.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
  * 自购电脑申请
  *
  * @author lemon
  * @date 2023-09-19
  */
@Getter
@Setter
public class TDeviceApplyVO extends BaseViewModel implements Serializable {
    /** 申请单号 */
    @ApiModelProperty("申请单号")
    private String applyNo;
    /** 申请状态 */
    @ApiModelProperty("申请状态")
    private String applyStatus;
    @UdcName(udcName = "ADMINISTRATION:DEVICE_APPLY_STATUS", codePropName = "applyStatus")
    private String applyStatusDesc;
    /** 申请日期 */
    @ApiModelProperty("申请日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate applyDate;
    /** 申请人资源ID */
    @ApiModelProperty("申请人资源ID")
    private Long applyResId;
    @ApiModelProperty("申请人资源")
    @UdcName(udcName = "USER", codePropName = "applyResId")
    private String applyResName;
    /** 每月补贴金额 */
    @ApiModelProperty("每月补贴金额")
    private BigDecimal monthlyAmt;
    /** 票据号 */
    @ApiModelProperty("票据号")
    private String billNo;
    /** 品牌型号及颜色 */
    @ApiModelProperty("品牌型号及颜色")
    private String deviceDesc;
    /** 内存 */
    @ApiModelProperty("内存")
    private String memSize;
    /** 硬盘 */
    @ApiModelProperty("硬盘")
    private String hdSize;
    /** 购置价格 */
    @ApiModelProperty("购置价格")
    private BigDecimal devicePrice;
    /** 购置日期 */
    @ApiModelProperty("购置日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate buyDate;
    /** 补贴起始月份 */
    @ApiModelProperty("补贴起始月份")
    private Integer startPeriodId;
    /** 申请理由 */
    @ApiModelProperty("申请理由")
    private String applyDesc;
    /** 申请人BU_ID */
    @ApiModelProperty("申请人BU_ID")
    private Long resBuId;
    @ApiModelProperty("申请人BU")
    @UdcName(udcName = "BU", codePropName = "resBuId")
    private String resBuName;

    /** 附件 */
    @ApiModelProperty("附件")
    private String fileCode;
    /**
     * 文件数据
     */
    @ApiModelProperty("文件数据")
    private Object fileData;
    /** 流程实例ID */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /** 流程审批状态 */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    @UdcName(udcName = "appr_status", codePropName = "procInstStatus")
    private String procInstStatusDesc;
    /** 提交时间 */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /** 审批时间 */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    /**
     * 主服务地址
     */
    @ApiModelProperty("主服务地址")
    private String baseCity;
}
