package com.elitesland.tw.tw5.api.prd.partner.strategy.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 分级策略等级配置
 *
 * @author wangly
 * @date 2023-06-16
 */
@Getter
@Setter
public class BusinessStrategyGradeSettingQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 策略id business_strategy.id 精确 */
    @ApiModelProperty("策略id business_strategy.id")
    private Long strategyId;
    /** 等级类别 udc[crm:customer_grade] 精确 */
    @ApiModelProperty("等级类别 udc[crm:customer_grade]")
    private String gradleType;
    /** 分数开始 精确 */
    @ApiModelProperty("分数开始")
    private BigDecimal scoreStart;
    /** 分数结束 精确 */
    @ApiModelProperty("分数结束")
    private BigDecimal scoreEnd;
    /** 排序号 精确 */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /** 拓展字段1 精确 */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /** 拓展字段2 精确 */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /** 拓展字段3 精确 */
    @ApiModelProperty("拓展字段3")
    private String ext3;
    /** 拓展字段4 精确 */
    @ApiModelProperty("拓展字段4")
    private String ext4;
    /** 拓展字段5 精确 */
    @ApiModelProperty("拓展字段5")
    private String ext5;
}
